package jp.sourceforge.cfneo.at4ie.api.impl.ie;

import java.lang.reflect.Constructor;

import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;
import jp.sourceforge.cfneo.at4ie.api.ActionCommandEnum;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.InvokerFactory;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;

import org.apache.log4j.Logger;


/**
 * Invoker̃t@NgB
 * @author imaitakafumi
 *
 */
public class AT4IEInvokerFactory extends InvokerFactory {

	Logger logger = Logger.getLogger(AT4IEInvokerFactory.class);

	private static AT4IEInvokerFactory _instance;

	/**
	 * IEInvokerFactorỹCX^X𐶐B
	 * @return
	 */
	public static AT4IEInvokerFactory getInstance(Context context) {
		if (_instance == null) {
			_instance = new AT4IEInvokerFactory(context);
		}
		return _instance;
	}

	private AT4IEInvokerMap invokerMap;
	private TargetBrowser browser;

	/**
	 * RXgN^B
	 * @param context
	 */
	private AT4IEInvokerFactory(Context context) {
		super(context);
		this.browser = new AT4IEInternetExplorer();
		this.invokerMap = new AT4IEInvokerMap();
	}

	@Override
	public Invoker getInvoker(ActionCommandEnum command) {
		try {
			logger.debug("action=" + command.toString());
			Class<?>[] clazz = {Context.class, TargetBrowser.class};
			Constructor<?> constructor = this.invokerMap.getInvokerClass(
					command).getConstructor(clazz);
			return (Invoker) constructor.newInstance(
					this.getContext(), this.browser);
		} catch (Exception e) {
			throw new AT4IERuntimeException(e);
		}
	}

}
