package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import jp.sourceforge.cfneo.at4ie.api.AT4IEAssertException;
import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;
import jp.sourceforge.cfneo.at4ie.api.Context;
import jp.sourceforge.cfneo.at4ie.api.ElementLocatorEnum;
import jp.sourceforge.cfneo.at4ie.api.Invoker;
import jp.sourceforge.cfneo.at4ie.api.TargetBrowser;
import jp.sourceforge.cfneo.at4ie.api.TestCase;
import jp.sourceforge.cfneo.at4ie.utils.LocatorUtil;

import org.apache.log4j.Logger;

/**
 * command=selectInvokerB<br />
 * y[Wselect̒l̑IsB
 * @author imaitakafumi
 *
 */
public class SelectInvoker extends Invoker {

	Logger logger = Logger.getLogger(SelectInvoker.class);

	/**
	 * RXgN^B
	 * @param context
	 * @param browser
	 */
	public SelectInvoker(Context context, TargetBrowser browser) {
		super(context, browser);
	}

	@Override
	public void invoke(TestCase testCase) throws AT4IEAssertException {
		logger.debug("SelectInvoker#invoke testCase=" + testCase.toString());
		try {
			ElementLocatorEnum elem = LocatorUtil
					.getElementLocatorEnum(testCase.getTarget());
			logger.debug("SelectInvoker#invoke elem=" + elem.toString());
			switch (elem) {
			case DOM:
				break;
			case ID:
				super.getBrowser().selectById(
						testCase.getElementValue(), testCase.getValue());
				break;
			case IDENTIFIER:
				break;
			case LINK:
				break;
			case NAME:
				super.getBrowser().selectByName(
						testCase.getElementValue(), testCase.getValue());
				break;
			case XPATH:
				break;
			case VALUE:
				break;
			case OTHER:
				break;
			}
		} catch (Exception e) {
			throw new AT4IERuntimeException(e);
		}
	}

}
