package jp.sourceforge.cfneo.at4ie.utils;

import jp.sourceforge.cfneo.at4ie.api.AT4IERuntimeException;

import org.apache.log4j.Logger;

/**
 * ԕ\L(xx:xx/xx:xx:xx)\NXB
 * @author imaitakafumi
 *
 */
public class AT4IETimeFormat {

	Logger logger = Logger.getLogger(AT4IETimeFormat.class);
	private Long h, m, s;

	/**
	 * RXgN^B
	 * @param value
	 */
	public AT4IETimeFormat(String value) {
		if (AT4IEStringUtil.isTimeFormat(value) == false) {
			throw new AT4IERuntimeException("Value is not Time format string.");
		}
		String[] values = value.split(":");
		if (values.length >= 2) {
			this.m = new Long(values[values.length - 2]);
			this.s = new Long(values[values.length - 1]);
		}
		if (values.length == 3) {
			this.h = new Long(values[values.length - 3]);
		} else {
			this.h = new Long(0L);
		}
		logger.debug("AT4IETimeFormat#AT4IETimeFormat h="
				+ (this.h== null?"null":this.h.longValue())
				+ "/m=" + this.m.longValue()
				+ "/s=" + this.s.longValue());
	}
	/**
	 * bSĕbŎ擾B
	 * @return
	 */
	public long getSecondValue() {
		return (h.longValue() * 24 * 60 * 60) + (m.longValue() * 60) + s.longValue();
	}

	public Long getH() {
		return h;
	}
	public Long getM() {
		return m;
	}
	public Long getS() {
		return s;
	}

}
