package jp.sourceforge.cfneo.at4ie.utils;

import jp.sourceforge.cfneo.at4ie.api.ElementLocatorEnum;

import org.apache.log4j.Logger;

/**
 * targetElementLocatorw肳ꂽۂɁALocator̎ނƒl擾ׂ̃[eBeBB
 * @author imaitakafumi
 *
 */
public class LocatorUtil {

	private static final String EQUALS = "=";
	private static final String dOUBLE_QUOTATION = "\"";

	static Logger logger = Logger.getLogger(LocatorUtil.class);

	/**
	 * ElementLocator̎ނ𔻕ʂElementLocatorEnumƂĎ擾B
	 * @param target
	 * @return
	 */
	public static ElementLocatorEnum getElementLocatorEnum(String target) {
		logger.debug("LocatorUtil#getElementLocatorEnum(String) target=[" + target + "]");
		if (target == null) {
			return null;
		}
		if (target.indexOf(EQUALS) > 0) {
			String[] s1 = target.split(EQUALS);
			ElementLocatorEnum e = ElementLocatorEnum.get(s1[0].trim());
			if (e != null) {
				return e;
			}
		}
		return ElementLocatorEnum.OTHER;
	}

	/**
	 * ElementLocatorɎw肳ꂽvalue𒊏oĎ擾B
	 * @param target
	 * @return
	 */
	public static String getLocatorValue(String target) {
		if (target == null) {
			return null;
		}
		ElementLocatorEnum elem = getElementLocatorEnum(target);
		String s1 = target.trim().replaceAll(elem.toString(), "").replaceAll(EQUALS, "");
		String s2 = deleteDoubleQuotation(s1);
		return s2;
	}

	/**
	 * O_uENH[e[Vň͂܂Ă镶񂾂ꍇÃ_uENH[e[VB
	 * @param s
	 * @return
	 */
	public static String deleteDoubleQuotation(String s) {
		logger.debug("deleteDoubleQuotation:s=" + s);
		if (s == null || s.length() == 0) {
			return s;
		}
		if (s.equals("\"\"")) {
			return "";
		}
		if (s.substring(0, 1).equals(dOUBLE_QUOTATION)
				&& s.substring(s.length() - 1, s.length()).equals(dOUBLE_QUOTATION)) {
			return s.trim().substring(1, s.length() - 1);
		}
		return s;
	}

}
