package jp.sourceforge.cfneo.at4ie.api.impl.ie.invoker;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;
import jp.sourceforge.cfneo.at4ie.api.ActionCommandEnum;
import jp.sourceforge.cfneo.at4ie.api.impl.DefaultTestCase;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.AT4IEInternetExplorer;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.DefaultContext;

import org.junit.Test;

/**
 * OpenInvoker̃eXgB
 * @author imaitakafumi
 *
 */
public class OpenInvokerTest {

	static final String TEST_PAGE = "D:\\home\\eclipse-jee-europa-winter-win32\\eclipse\\workspace\\AutoTester4IE\\src\\test\\resources\\htmltest\\watijtest1.html";

	/**
	 * HTMLt@CQƂB
	 */
	@Test
	public void testInvoke_1() {
		try {
			AT4IEInternetExplorer ie = new AT4IEInternetExplorer();
			OpenInvoker invoker = new OpenInvoker(null, ie);
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_OPEN, TEST_PAGE, null);
			invoker.invoke(testcase);
			assertEquals("Test Page", ie.title());
			ie.close();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
	/**
	 * GoogleQƂB
	 */
	@Test
	public void testInvoke_2() {
		try {
			AT4IEInternetExplorer ie = new AT4IEInternetExplorer();
			OpenInvoker invoker = new OpenInvoker(null, ie);
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_OPEN,
					"http://www.google.co.jp/",
					null);
			invoker.invoke(testcase);
			assertEquals("Google", ie.title());
			ie.close();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
	/**
	 * ݂Ȃt@CQƂB
	 */
//	@Test
	public void testInvoke_3() {
		AT4IEInternetExplorer ie = new AT4IEInternetExplorer();
		try {
			OpenInvoker invoker = new OpenInvoker(null, ie);
			DefaultTestCase testcase = new DefaultTestCase(
					new DefaultContext(),
					ActionCommandEnum.ACTION_OPEN,
					"D:\\home\\eclipse-jee-europa-winter-win32\\eclipse\\workspace\\AutoTester4IE\\src\\test\\resources\\htmltest\\watijtest_x.html",
					null);
			invoker.invoke(testcase);
			System.err.println(ie.alertDialog().text());
			fail();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				ie.close();
			} catch (Exception e) {
				;
			}
		}
	}

}
