package misc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.junit.Test;

import watij.finders.FinderFactory;
import watij.runtime.ie.IE;

/**
 * WatiĵꂱẴׂ݂eXgNXB
 * @author imaitakafumi
 *
 */
public class WatijTest1 {

	@Test
	public void test1_uEU\() {
		try {
			IE ie = new IE();
			ie.start("http://www.google.co.jp/");
			assertEquals("Google", ie.title());
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss");
			ie.textField(0).set("watij");
			ie.button(0).click();
			ie.windowCapture("src/test/resources/AutoTester4IE/" + sdf.format(new Date()) + ".png");
			System.out.println("now=" + ie.url());
		} catch(Exception e) {
			e.printStackTrace();
			fail();
		}
	}

//	@Test
	public void test2_eLXg() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss");
		try {
			IE ie = new IE();
			ie.start("http://www.google.co.jp/");
			System.out.println(":" + ie.textField(0).name());
			System.out.println("ie.textFields().length():" + ie.textFields().length());
			for (int i = 0; i < ie.textFields().length(); i++) {
				System.err.println(i + ":" + ie.textField(i).name());
				if (ie.textField(i).name().equals("q")) {
					ie.textField(i).set("java-ja" + i);
				}
			}
			ie.windowCapture("src/test/resources/AutoTester4IE/" + sdf.format(new Date()) + ".png");
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

//	@Test
	public void test3_submit{try1() {
		try {
			IE ie = new IE();
			ie.start("http://gree.appspot.com/");
			ie.textField(0).set("test2");
			ie.button(0).click();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

//	@Test
	public void test3_submit{try2() {
		try {
			IE ie = new IE();
			ie.start("http://gree.appspot.com/");
			ie.textField(0).set("test3");
			ie.button(FinderFactory.method("post")).click();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

//	@Test
	public void test4_submit{try3() {
		try {
			IE ie = new IE();
			ie.start("http://gree.appspot.com/");
			ie.textField(0).set("test3");
			System.out.println(":" + ie.button(0).value());
			System.out.println(":" + ie.button(0).type());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

//	@Test
	public void testWatij() {
		try {
			IE ie = new IE();
			ie.start("http://www.google.co.jp/");
			assertEquals("Google", ie.title());
			ie.windowCapture("src/test/resources/watijtest1.png");
			ie.textField(0).set("VI l^");
			Thread.sleep(1000L);
			ie.windowCapture("src/test/resources/watijtest2.png");
			ie.button(0).click();
			assertEquals("VI l^ - Google ", ie.title());
			Thread.sleep(1000L);
			ie.windowCapture("src/test/resources/watijtest3.png");
			ie.link(FinderFactory.href("http://d.hatena.ne.jp/Yoshiori/20080630/1214814814")).click();
			assertEquals("݂l^Ȃ - YoshioriBlog", ie.title());
			Thread.sleep(1000L);
			ie.windowCapture("src/test/resources/watijtest4.png");
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}
}
