package misc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.AT4IEButton;
import jp.sourceforge.cfneo.at4ie.api.impl.ie.ButtonClicker;

import org.junit.Test;

import watij.elements.HtmlElement;
import watij.elements.SelectList;
import watij.elements.SelectLists;
import watij.elements.TextField;
import watij.finders.SymbolFactory;
import watij.runtime.ie.IE;

public class WatijTest3 extends AbstractTestCase {

	@Test
	public void test_1() {
		try {
			this.ie.start(TEST_PAGE);
			System.out.println(this.ie.exists());
			System.out.println("[1]id=" + this.ie.selectList(0).id());
			System.out.println("[1]value=" + this.ie.selectList(0).value());
			System.out.println("[1]text=" + this.ie.selectList(0).text());
			this.ie.selectList(0).selectValue("bbb");
			System.out.println("[2]id=" + this.ie.selectList(0).id());
			System.out.println("[2]value=" + this.ie.selectList(0).value());
			System.out.println("[2]text=" + this.ie.selectList(0).text());
			this.ie.screenCapture("src/test/resources/test_test1.png");
			this.ie.close();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_2() {
		try {
			this.ie.start(TEST_PAGE);

			SelectLists sels = this.ie.selectLists();
			SelectList sel = null;
			for (SelectList s: sels) {
				if (s.id().equals("select1")) {
					sel = s;
					break;
				}
			}
			System.err.println("html=" + sel.html());
			System.out.println("value=" + sel.value());
			System.err.println("text=" + sel.text());
			System.err.println("id=" + sel.id());
			System.err.println("chooseValue.text=" + sel.option(SymbolFactory.value, sel.value()).text());

			this.ie.close();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_3() {
		try {
			this.ie.start(TEST_PAGE);
			this.ie.button(SymbolFactory.id, "btn0").click();
			assertEquals("btn0", this.ie.getTextValueById("txt0"));
			this.ie.typeById("txt0", "");
			assertEquals("", this.ie.getTextValueById("txt0"));
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_4() {
		try {
			this.ie.start(TEST_PAGE);
			this.ie.button(SymbolFactory.value, "click").click();
			this.ie.typeById("txt0", "");
			assertEquals("", this.ie.textField(SymbolFactory.id, "txt0").value());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_5() {
		try {
			this.ie.start(TEST_PAGE);
			this.ie.button(SymbolFactory.id, "btn3").click();
			assertEquals(1, this.ie.childBrowserCount());
			Thread.sleep(1000L);
			IE child = this.ie.childBrowser();
			System.out.println("child.url()=" + child.url());
			child.button(0).click();
			assertEquals(1, this.ie.childBrowserCount());
			System.err.print("BEFORE close");
			child.close();
			System.err.print("BEFORE childBrowserCount");
			assertEquals(0, this.ie.childBrowserCount());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_6() {
		try {
			this.ie.start(TEST_PAGE);
			String id = "btn0";
			HtmlElement elem = null;
			elem = this.ie.htmlElement(SymbolFactory.id, id);
			System.out.println("Element get!! value=" + elem.value() + "/type=" + elem.type());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_7() {
		try {
			this.ie.start(TEST_PAGE);
			TextField text = this.ie.textField(SymbolFactory.id, "txt0");
			System.out.println("text.name()=" + text.name());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_8() {
		try {
			this.ie.start(TEST_PAGE);
			Thread t = new Thread(
					new ButtonClicker(
							new AT4IEButton(
									this.ie.button(SymbolFactory.id, "btn2"),
									this.ie)));
			t.start();
			Thread.sleep(500L);
			t = null;
			System.out.println(this.ie.confirmDialog().title());
			System.out.println(this.ie.confirmDialog().text());
			this.ie.confirmDialog().ok();
			assertEquals("yes", this.ie.textField(SymbolFactory.id, "txt1").value());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

	@Test
	public void test_9() {
		try {
			this.ie.start(TEST_PAGE);
			Thread t = new Thread(
					new ButtonClicker(
							new AT4IEButton(
									this.ie.button(SymbolFactory.id, "btn2"),
									this.ie)));
			t.start();
			Thread.sleep(500L);
			t = null;
			this.ie.sendKeys("Microsoft Internet Explorer", " ");
			System.out.println(this.ie.confirmDialog().title());
			System.out.println(this.ie.confirmDialog().text());
			this.ie.confirmDialog().cancel();
			assertEquals("no", this.ie.textField(SymbolFactory.id, "txt1").value());
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
	}

}
