using System;
using System.Collections.Generic;
using System.Windows.Forms;
using ChaKi.Service.Search;
using System.Threading;
using ChaKi.Entity.Search;
using ChaKi.Common;

namespace ChaKi
{
    /// <summary>
    /// R}h̎sԂǗpl
    /// R}h҂s(Queue)ƒP̃XbhA
    /// L[ɓꂽServiceCommands
    /// </summary>
    public partial class CommandPanel : Form
    {
        public BeginSearchDelegate OnBeginSearch = null;
        public BeginSearchDelegate OnNarrowSearch = null;
        public BeginSearchDelegate OnBeginWordList = null;

        private Queue<IServiceCommand> m_CommandQueue;
        private Thread m_Thread;
        private bool m_bThreadQuit;
        private CommandProgress m_Progress;
        private bool m_bModelUpdate;

        public CommandPanel()
        {
            m_CommandQueue = new Queue<IServiceCommand>();
            m_Thread = new Thread(new ThreadStart(this.CommandProcess));

            m_bModelUpdate = false;

            m_Progress = null;

            InitializeComponent();

            this.timer1.Start();

            m_bThreadQuit = false;
            m_Thread.Start();
        }

        public void SetModel(CommandProgress model)
        {
            m_Progress = model;
            if (m_Progress != null)
            {
                m_Progress.OnModelChanged += new EventHandler(this.ModelChangedHandler);
            }
            RefreshView();
        }

        /// <summary>
        /// gp̃\[XׂăN[Abv܂B
        /// </summary>
        /// <param name="disposing">}l[W \[Xjꍇ trueAjȂꍇ false łB</param>
        protected override void Dispose(bool disposing)
        {
            if (disposing && (components != null))
            {
                components.Dispose();
            }
            m_bThreadQuit = true;
            base.Dispose(disposing);
        }


        /// <summary>
        /// Xbh𒆒f
        /// </summary>
        /// <param name="restart"></param>
        public void Abort(bool restart)
        {
            try
            {
                m_Thread.Abort();
            }
            catch
            {
                MessageBox.Show("Error in Thread Aborting.");
            }
            if (restart)
            {
                // wait for thread termination
                m_Thread.Join(30000);
                for (int ntry = 0; ntry < 100; ntry++)
                {
                    if (m_Thread.ThreadState == ThreadState.Stopped)
                    {
                        break;
                    }
                    Thread.Sleep(100);
                }
                m_CommandQueue.Clear();
                // Thread̍ċN
                m_Thread = new Thread(new ThreadStart(this.CommandProcess));
                m_Thread.Start();
                EnableCommandButtons(true);
            }
        }


        private void button3_Click(object sender, EventArgs e)
        {
            Abort(true);
        }

        /// <summary>
        /// R}hL[Ɏ󂯓
        /// </summary>
        /// <param name="cmd"></param>
        public void QueueCommand(IServiceCommand cmd)
        {
            m_CommandQueue.Enqueue(cmd);
        }

        /// <summary>
        /// XbhɂR}hfBXpb`{
        /// </summary>
        private void CommandProcess()
        {
            while (!m_bThreadQuit)
            {
                if (m_CommandQueue.Count > 0)
                {
                    IServiceCommand cmd = m_CommandQueue.Dequeue();
                    EnableCommandButtons(false);
                    try
                    {
                        cmd.Begin();
                    }
                    catch (Exception e)
                    {
                        if (!(e is ThreadAbortException))
                        {
                            ErrorReportDialog dlg = new ErrorReportDialog("Error while executing query commands:", e);
//                            AddOwnedForm(dlg);    // InvokegKv
                            dlg.ShowDialog();
                        }
                    }
                    EnableCommandButtons(true);
                }
                else
                {
                    Thread.Sleep(100);
                }
            }
        }

        public bool CanBeginSearch
        {
            get
            {
                return this.searchToolStripButton.Enabled;
            }
        }

        public bool CanNarrowSearch
        {
            get
            {
                return this.narrowToolStripMenuItem.Enabled;
            }
        }

        private delegate void ButtonEnableDelegate(int index, bool enabled);

        private void EnableCommandButtons( bool enabled )
        {
            ButtonEnableDelegate dele = (int i, bool f) => { this.toolStrip1.Items[i].Enabled = f; };
            if (this.toolStrip1.InvokeRequired)
            {
                this.toolStrip1.Invoke(dele, new object[] { 0, enabled });
            }
            else
            {
                this.searchToolStripButton.Enabled = enabled;
            }
            if (this.toolStrip1.InvokeRequired)
            {
                this.toolStrip1.Invoke(dele, new object[] { 1, enabled });
            }
            else
            {
                this.wordListToolStripButton.Enabled = enabled;
            }
        }


        public CommandProgress Model
        {
            get { return m_Progress; }
        }

        public void ModelChangedHandler(object sender, EventArgs e)
        {
            m_bModelUpdate = true;
        }

        /// <summary>
        /// Obhe̔񓯊ĕ`揈
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void timer1_Tick(object sender, EventArgs e)
        {
            if (m_bModelUpdate)
            {
                if (m_Progress.Items.Count != this.dataGridView1.RowCount)
                {
                    // sǉꂽ̂ŁAŜ`悵Ȃ
                    RefreshView();
                }
                else
                {
                    CommandProgressItem item = m_Progress.Current;
                    int row;
                    if (item != null)
                    {
                        row = item.Row;
                        this.dataGridView1.Rows[row].Cells[3].Value = string.Format("{0}", item.Nhit);
                        this.dataGridView1.Rows[row].Cells[4].Value =
                            item.Nc!=0 ? string.Format("{0:F4}", item.NhitP) : "--";
                        this.dataGridView1.Rows[row].Cells[5].Value = string.Format("{0}", item.Nret);
                        this.dataGridView1.Rows[row].Cells[6].Value =
                            item.Nhit!=0 ? string.Format("{0:F1}", item.NretP) : "--";
                    }
                    item = m_Progress.Total;
                    row = item.Row;
                    this.dataGridView1.Rows[row].Cells[3].Value = string.Format("{0}", item.Nhit);
                    this.dataGridView1.Rows[row].Cells[4].Value = 
                        item.Nc!=0 ? string.Format("{0:F4}", item.NhitP) : "--";
                    this.dataGridView1.Rows[row].Cells[5].Value = string.Format("{0}", item.Nret);
                    this.dataGridView1.Rows[row].Cells[6].Value = 
                        item.Nhit!=0 ? string.Format("{0:F1}", item.NretP) : "--";
                }
                m_bModelUpdate = false;
            }
        }

        private void RefreshView()
        {
            this.dataGridView1.SuspendLayout();
            this.dataGridView1.Rows.Clear();
            foreach (CommandProgressItem item in m_Progress.Items)
            {
                object[] rowdata = new object[] {
                            item.Title,
                            string.Format( "{0}", item.Nc ),
                            string.Format( "{0}", item.Nd ),
                            string.Format( "{0}", item.Nhit ),
                            item.Nc!=0? string.Format( "{0:F4}", item.NhitP ):"--",
                            string.Format( "{0}", item.Nret ),
                            item.Nhit!=0? string.Format( "{0:F1}", item.NretP ):"--"
                        };
                if (item.Title.Equals("TOTAL"))
                {
                    rowdata[2] = string.Empty;
                }
                this.dataGridView1.Rows.Add(rowdata);
            }
            this.dataGridView1.ResumeLayout();
        }

        /// <summary>
        /// Search{^ꂽƂ̏
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void searchStripSplitButton_ButtonClick(object sender, EventArgs e)
        {
            if (OnBeginSearch != null)
            {
                OnBeginSearch();
            }
        }

        /// <summary>
        /// Search-New{^ꂽƂ̏
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void newSearchToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (OnBeginSearch != null)
            {
                OnBeginSearch();
            }
        }

        /// <summary>
        /// Search-Narrow{^ꂽƂ̏
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void narrowToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (OnNarrowSearch != null)
            {
                OnNarrowSearch();
            }
        }

        /// <summary>
        /// Search-Append{^ꂽƂ̏
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void appendToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //@todo
        }

        /// <summary>
        /// WordCount{^ꂽƂ̏
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void wordListToolStripButton_Click(object sender, EventArgs e)
        {
            if (OnBeginWordList != null)
            {
                OnBeginWordList();
            }
        }

        /// <summary>
        /// Collocation{^ꂽƂ̏
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void collocationToolStripButton_Click(object sender, EventArgs e)
        {
            throw new NotImplementedException();

        }

        /// <summary>
        /// Abort{^ꂽƂ̏
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void abortToolStripButton_Click(object sender, EventArgs e)
        {
            Abort(true);
        }
    }
}