﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;

namespace ChaKi.Common
{
    public partial class DepArrowControl : UserControl
    {
        public bool Selected { get; set; }

        private static Pen m_Pen;
        private static Pen m_SelPen;

        static DepArrowControl()
        {
            m_Pen = new Pen(Color.Black, 2F);
            m_Pen.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
            m_SelPen = new Pen(Color.Red, 2F);
            m_Pen.EndCap = System.Drawing.Drawing2D.LineCap.ArrowAnchor;
        }

        public DepArrowControl()
        {
            InitializeComponent();
            this.Size = new Size(15, 15);
        }

        private void DepArrowControl_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            Pen pen = this.Selected ? m_SelPen : m_Pen;
            Point[] pts = new Point[]
            {
                new Point(0,0),
                new Point(0,this.Height),
                new Point(this.Width-4,this.Height),
                new Point(this.Width-4,0)
            };

            g.DrawLines(pen, pts);

        }
    }
}
