using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity;
using ChaKi.Entity.Search;
using ChaKi.Entity.Corpora;
using System.Drawing.Text;
using ChaKi.Entity.Settings;

namespace ChaKi.Common
{
    public delegate void PropertyInputDone(object sender, InputDoneEventArgs e);
    public delegate void PropertyInputCancel(object sender, KeyPressEventArgs e);
    public delegate void PropertyBoxCenterized(object sender, EventArgs e);

    public partial class PropertyBox : UserControl
    {
        #region static fields
        private static List<string> m_tags;
        private static Font m_font;
        private static Brush m_brush;
        private static Font m_font2;
        private static Brush m_brush2;
        private static Brush m_brush3;
        private static Brush m_brush4;
        private static Pen m_pen;
        private static TransparentInputForm m_inputDlg;
        #endregion

        private LexemeCondition m_Model;

        public event EventHandler OnCenterizedButtonClicked;
        public event EventHandler OnDeleteClicked;
        public event MouseEventHandler OnMouseDownEvent;

        public bool ShowRange {
            get
            {
                return this.textBox1.Visible;
            }
            set
            {
                this.textBox1.Visible = value;
                this.textBox2.Visible = value;
                this.label1.Visible = value;
            }
        }

        public bool IsPivot
        {
            get { return m_Model.IsPivot; }
            set { m_Model.IsPivot = value; }
        }

        /// <summary>
        /// Range̐ݒE擾
        /// </summary>
        public Range Range
        {
            get
            {
                SynchronizeRange();
                return m_Model.RelativePosition;
            }
            set
            {
                m_Model.RelativePosition = value;
                this.textBox1.Text = string.Format("{0}", m_Model.RelativePosition.Start);
                this.textBox2.Text = string.Format("{0}", m_Model.RelativePosition.End);
            }
        }

        public void OffsetRange(int offset)
        {
            m_Model.OffsetRange(offset);
            this.textBox1.Text = string.Format("{0}", m_Model.RelativePosition.Start);
            this.textBox2.Text = string.Format("{0}", m_Model.RelativePosition.End);
        }

        static PropertyBox()
        {
            m_tags = new List<string>();
            foreach (KeyValuePair<LP, string> pair in Lexeme.PropertyName)
            {
                m_tags.Add(pair.Value);
            }
            m_font = new Font("lr oSVbN", 9);
            m_font2 = new Font("Lucida Sans Unicode", 8, FontStyle.Italic);
            m_brush = new SolidBrush(Color.Black);
            m_brush2 = new SolidBrush(Color.MediumSlateBlue);
            m_brush3 = new SolidBrush(Color.White);
            m_brush4 = new SolidBrush(Color.Red);
            m_pen = new Pen(Color.Red, 2);

            // inputp̃|bvAbv쐬
            m_inputDlg = new TransparentInputForm();
        }       
        
        public PropertyBox(LexemeCondition model)
        {
            InitializeComponent();

            // Popup FormMainForm̎qFormƂ
            if (Program.MainForm == null)
            {
                throw new Exception("Set PropertyBox.m_RootParent before crating a PropertyBox instance.");
            }
            Program.MainForm.AddOwnedForm(m_inputDlg);

            // PropertyBox̏
            foreach (string tag in m_tags)
            {
                this.listBox1.Items.Add(tag);
            }

            // Model̏
            m_Model = model;
            this.Range = model.RelativePosition;
        }

        private void listBox1_DrawItem(object sender, DrawItemEventArgs e)
        {
            int index = e.Index;
            if (index < 0 || index >= m_tags.Count)
            {
                return;
            }
            Rectangle r = e.Bounds;
            using (Graphics g = e.Graphics)
            {
                g.FillRectangle(m_brush3, e.Bounds);

                // eLXg̕Lɂ
                g.TextRenderingHint = TextRenderingHint.ClearTypeGridFit;

                PropertyPair pair = m_Model.FindProperty(m_tags[index]); 
                if (pair != null)
                {
                    if (pair.Value.IsRegEx)
                    {
                        g.DrawString(pair.Value.StrVal, m_font, m_brush4, r);
                    }
                    else
                    {
                        g.DrawString(pair.Value.StrVal, m_font, m_brush, r);
                    }
                }
                else
                {
                    g.DrawString("<"+m_tags[index]+">", m_font2, m_brush2, r);
                }
            }
        }

        /// <summary>
        /// ListBox̍ڕҏW
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            int index = listBox1.SelectedIndex;
            if (index < 0)
            {
                return;
            }

            // ̓_CAȌl߂
            string val = "";
            bool isRegex = false;
            bool isCaseSensitive = true;
            PropertyPair pair = m_Model.FindProperty(m_tags[index]);
            if (pair != null)
            {
                val = pair.Value.StrVal;
                isRegex = pair.Value.IsRegEx;
                isCaseSensitive = pair.Value.IsCaseSensitive;
            }

            Rectangle r = listBox1.GetItemRectangle(index);
            r = listBox1.RectangleToScreen(r);

            if (m_tags[index] == Lexeme.PropertyName[LP.PartOfSpeech])
            {
                m_inputDlg.HasTreeSelection = true;
                // Selection(Tree)POSpӂ
                m_inputDlg.TreePopup.PopulateWithPOSSelections();
            }
            else if (m_tags[index] == Lexeme.PropertyName[LP.CType])
            {
                m_inputDlg.HasTreeSelection = true;
                // Selection(Tree)CTypepӂ
                m_inputDlg.TreePopup.PopulateWithCTypeSelections();
            }
            else if (m_tags[index] == Lexeme.PropertyName[LP.CForm])
            {
                m_inputDlg.HasTreeSelection = true;
                // Selection(Tree)CFormpӂ
                m_inputDlg.TreePopup.PopulateWithCFormSelections();
            }
            else
            {
                m_inputDlg.HasListSelection = true;
                m_inputDlg.ListPopup.PopulateWithUserHistory(m_tags[index]);
            }
            m_inputDlg.ReturnFocusTo = listBox1;
            m_inputDlg.PopupLocation = new Point(r.Left, r.Top);
            m_inputDlg.Bounds = Program.MainForm.Bounds;
            PropertyInputDialog popup = m_inputDlg.Popup;
            // ̓_CAȌlݒ
            popup.Index = index;
            popup.EditText = val;
            popup.IsRegEx = isRegex;
            popup.IsCaseSensitive = isCaseSensitive;
            // inputĨnhݒ肷
            popup.OnInputDone += this.OnPropertyInputDone;
            popup.OnInputCancel += this.OnPropertyInputCancel;
            m_inputDlg.Show();
            m_inputDlg.Popup.Select();  // wi݂邽߁ASelectȂƃtH[JXPopupɐݒ肳Ȃ
        }

        public void OnPropertyInputDone(object sender, InputDoneEventArgs e)
        {
            // InputDialog̒ʒm𒆎~
            PropertyInputDialog popup = m_inputDlg.Popup;
            popup.OnInputDone -= this.OnPropertyInputDone;
            popup.OnInputCancel -= this.OnPropertyInputCancel;

            string key = m_tags[e.Index];
            // ̎ʂɉProperty쐬
            Property p;
            if (m_tags[e.Index] == Lexeme.PropertyName[LP.PartOfSpeech])
            {
                p = new PartOfSpeech(e.Text);
            }
            else if (m_tags[e.Index] == Lexeme.PropertyName[LP.CType])
            {
                p = new CType(e.Text);
            }
            else if (m_tags[e.Index] == Lexeme.PropertyName[LP.CForm])
            {
                p = new CForm(e.Text);
            }
            else
            {
                p = new Property(e.Text);
            }
            p.IsRegEx = popup.IsRegEx;
            p.IsCaseSensitive = popup.IsCaseSensitive;

            // PropertyLexemeConditionPropertyPairɒǉiPropertyPair͒uj
            PropertyPair pair = m_Model.FindProperty(key);
            if (pair == null)
            {
                if (e.Text.Length > 0)
                {
                    pair = new PropertyPair(key, p);
                    m_Model.PropertyPairs.Add(pair);
                }
            }
            else
            {
                if (e.Text.Length == 0)
                {
                    m_Model.RemoveProperty(key);
                }
                else
                {
                    pair.Value = p;
                }
            }
            m_inputDlg.Hide();

            // L[[h̗ɒǉ
            UserSettings.GetInstance().AddKeywordHistory(key, e.Text);
        }

        public void OnPropertyInputCancel(object sender, KeyPressEventArgs e)
        {
            m_inputDlg.Hide();
            // InputDialog̒ʒm𒆎~
            PropertyInputDialog popup = m_inputDlg.Popup;
            popup.OnInputDone -= this.OnPropertyInputDone;
            popup.OnInputCancel -= this.OnPropertyInputCancel;
        }

        public LexemeCondition GetCondition()
        {
            return m_Model;
        }

        public void SynchronizeRange()
        {
            int start = 0;
            int end = 0;
            Int32.TryParse(this.textBox1.Text, out start);
            Int32.TryParse(this.textBox2.Text, out end);
            m_Model.RelativePosition = new Range(start, end);
        }

        private void PropertyBox_Paint(object sender, PaintEventArgs e)
        {
            if (IsPivot)
            {
                Rectangle r = this.listBox1.Bounds;
                e.Graphics.DrawRectangle(m_pen, r);
            }
        }

        /// <summary>
        /// LexBox̃ReNXgj[\
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void listBox1_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                listBox1.ContextMenuStrip.Show(listBox1, e.Location);
            }
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {
            if (this.OnCenterizedButtonClicked != null) this.OnCenterizedButtonClicked(this, e);
        }

        private void centerizeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (this.OnCenterizedButtonClicked != null) this.OnCenterizedButtonClicked(this, e);
        }

        private void deleteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (this.OnDeleteClicked != null) this.OnDeleteClicked(this, e);
        }

        private void PropertyBox_MouseDown(object sender, MouseEventArgs e)
        {
            if (this.OnMouseDownEvent != null) this.OnMouseDownEvent(this, e);
        }
    }
}
