using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Search;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Settings;
using ChaKi.Service.Search;
using ChaKi.Common;
using ChaKi.Properties;
using System.Drawing;
using Crownwood.DotNetMagic.Controls;
using System.IO;
using System.Reflection;
using System.Drawing.Text;
using ChaKi.Service.Database;
using ChaKi.ToolDialogs;

namespace ChaKi.ConditionPanes
{
    public partial class CorpusPane : UserControl
    {
        private CorpusCondition m_Model;
        private List<Image> m_ImageList;
        private bool m_bSuppressUpdate;

        public CorpusPane(CorpusCondition model)
        {
            InitializeComponent();

            // WListViewSmallImageListgpƁAXPŉ掿Ȃ̂ŁA
            // DotNetMagicTreeView(List Style)gpB
            treeControl1.SetTreeControlStyle(TreeControlStyles.List);
            treeControl1.TextRenderingHint = TextRenderingHint.ClearTypeGridFit;
            
            m_ImageList = new List<Image>();
            using (Stream st = Assembly.GetExecutingAssembly().GetManifestResourceStream("ChaKi.Resources.SQLite_S.png"))
            {
                m_ImageList.Add(new Bitmap(st));
            }
            using (Stream st = Assembly.GetExecutingAssembly().GetManifestResourceStream("ChaKi.Resources.MySQL_S.png"))
            {
                m_ImageList.Add(new Bitmap(st));
            }
            using (Stream st = Assembly.GetExecutingAssembly().GetManifestResourceStream("ChaKi.Resources.MSSQL_S.png"))
            {
                m_ImageList.Add(new Bitmap(st));
            }

            m_Model = model;
            m_bSuppressUpdate = false;
            m_Model.OnModelChanged += new EventHandler(this.ModelChangedHandler);

            UpdateView();
        }
#if false
        public CorpusPane(IContainer container)
        {
            container.Add(this);
            InitializeComponent();

            m_Model = model;
            m_Model.OnModelChanged += this.ModelChangedHandler;

            UpdateView();
        }
#endif
        public void SetCondition(CorpusCondition cond)
        {
            m_Model = cond;
            m_Model.OnModelChanged += new EventHandler(this.ModelChangedHandler);
            UpdateView();
        }

        public CorpusCondition GetCondition()
        {
            return m_Model;
        }

        private void UpdateView()
        {
            treeControl1.SuspendLayout();
            treeControl1.Nodes.Clear();
            foreach (Corpus c in m_Model.Corpora)
            {
                string name = c.Name;
                Node node = new Node(name);
                if (c.DBParam.DBType.Equals("SQLite"))
                {
                    node.Image = m_ImageList[0];
                }
                else if (c.DBParam.DBType.Equals("MySQL"))
                {
                    node.Image = m_ImageList[1];
                }
                else if (c.DBParam.DBType.Equals("SQLServer"))
                {
                    node.Image = m_ImageList[2];
                }
                treeControl1.Nodes.Add(node);
                if (c == ChaKiModel.CurrentCorpus)
                {
                    m_bSuppressUpdate = true;   // AfterSelectCxgUɂċAIUpdate}
                    this.treeControl1.SelectedNode = node;
                    m_bSuppressUpdate = false;
                }
            }
            treeControl1.ResumeLayout();
        }

        public void ModelChangedHandler(object sender, EventArgs e)
        {
            UpdateView();
        }

        /// <summary>
        /// R[pXIԂɂꂽƂAChaKiModel.CurrentCorpusXV.
        /// m_bSuppressUpdateZbgĂΉsȂ.
        /// </summary>
        /// <param name="tc"></param>
        /// <param name="e"></param>
        private void treeControl1_AfterSelect(Crownwood.DotNetMagic.Controls.TreeControl tc, Crownwood.DotNetMagic.Controls.NodeEventArgs e)
        {
            if (m_bSuppressUpdate || e.Node == null)
            {
                return;
            }
            int index = e.Node.Index;
            if (index < 0 || index >= m_Model.Corpora.Count)
            {
                return;
            }
            ChaKiModel.CurrentCorpus = m_Model.Corpora[index];
        }

        /// <summary>
        /// Add{^ꂽƂAVȃR[pXꗗɒǉ鏈
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
            using (OpenFileDialog dlg = new OpenFileDialog())
            {
                dlg.Filter = "SQLite database files (*.db)|*.db|Corpus definition files (*.def)|*.def|All files (*.*)|*.* ";
                dlg.Title = "Select Corpus to Open";
                dlg.CheckFileExists = true;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    try
                    {
                        Corpus c = Corpus.CreateFromFile(dlg.FileName);
                        // R[pX̊{[hĂ
                        DBService dbs = DBService.Create(c.DBParam);
                        dbs.LoadMandatoryCorpusInfo(c);
                        m_Model.Corpora.Add(c);
                        ChaKiModel.CurrentCorpus = c;
                    }
                    catch (Exception ex)
                    {
                        ErrorReportDialog err = new ErrorReportDialog("Cannot add corpus", ex);
                        err.ShowDialog();
                    }
                }
            }
            UpdateView();
        }

        /// <summary>
        /// Del{^ꂽƂAIԂ̃R[pXꗗ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button2_Click(object sender, EventArgs e)
        {
            Node n = treeControl1.SelectedNode;
            if (n == null)
            {
                return;
            }
            int index = n.Index;
            if (index < 0 || index >= m_Model.Corpora.Count)
            {
                return;
            }
            try
            {
                m_Model.Corpora.RemoveAt(index);
            }
            catch (ArgumentOutOfRangeException)
            {
                MessageBox.Show("CorpusPane - Invalid Model");
            }
            UpdateView();
        }

        /// <summary>
        /// uv{^ꂽƂAIԂɂR[pX̗Dxグ鏈
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button4_Click(object sender, EventArgs e)
        {
            Node n = treeControl1.SelectedNode;
            if (n == null)
            {
                return;
            }
            int index = n.Index;
            if (index <= 0 || m_Model.Corpora.Count == 0 || index >= m_Model.Corpora.Count)
            {
                return;
            }
            Corpus c = m_Model.Corpora[index];
            m_Model.Corpora.RemoveAt(index);
            m_Model.Corpora.Insert(index - 1, c);
            UpdateView();
        }

        /// <summary>
        /// uv{^ꂽƂAIԂɂR[pX̗Dx鏈
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button5_Click(object sender, EventArgs e)
        {
            Node n = treeControl1.SelectedNode;
            if (n == null)
            {
                return;
            }
            int index = n.Index;
            if (index < 0 || m_Model.Corpora.Count == 0 || index >= m_Model.Corpora.Count - 1)
            {
                return;
            }
            Corpus c = m_Model.Corpora[index];
            m_Model.Corpora.RemoveAt(index);
            m_Model.Corpora.Insert(index + 1, c);
            UpdateView();
        }

        /// <summary>
        /// Show{^ꂽƂAIԂɂR[pX̏ڍׂ\鏈
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button3_Click(object sender, EventArgs e)
        {
            Node n = treeControl1.SelectedNode;
            if (n == null)
            {
                return;
            }
            int index = n.Index;
            if (index < 0 || index >= m_Model.Corpora.Count)
            {
                return;
            }
            Cursor oldCur = this.Cursor;
            this.Cursor = Cursors.WaitCursor;

            // R[pX̊{[hĂ
            Corpus c = m_Model.Corpora[index];
            DBService dbs = DBService.Create(c.DBParam);
            try
            {
                dbs.LoadCorpusInfo(c);
            }
            catch (Exception ex)
            {
                ExceptionDialogBox dlg = new ExceptionDialogBox();
                dlg.Text = ex.ToString();
                dlg.ShowDialog();
                return;
            }
            this.Cursor = oldCur;

            // Corpus Information _CAO\
            CorpusInfo cdlg = new CorpusInfo();
            cdlg.SetCorpus(c);
            cdlg.Show();
        }
    }
}
