using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ChaKi.Common;
using ChaKi.Entity.Search;
using System.Diagnostics;

namespace ChaKi.ConditionPanes
{
    public partial class TagSearchPane : UserControl
    {
        private TagSearchCondition m_Model;
        private List<PropertyBox> m_Boxes;

        public TagSearchPane( TagSearchCondition model )
        {
            InitializeComponent();

            m_Boxes = new List<PropertyBox>();

            m_Model = model;
            m_Model.OnModelChanged += new EventHandler( this.ModelChangedHandler );

            this.UpdateView();
        }

        public void SetCondition(TagSearchCondition cond)
        {
            m_Model = cond;
            m_Model.OnModelChanged += new EventHandler(this.ModelChangedHandler);
            UpdateView();
        }

        public TagSearchCondition GetCondition()
        {
            foreach (PropertyBox b in m_Boxes)
            {
                b.SynchronizeRange();
            }
            //this.UpdateView();
            return m_Model;
        }

        private void UpdateView()
        {
            Debug.WriteLine("TagSearchPane::UpdateView");

//            this.Visible = false;
            this.SuspendLayout();
            this.flowLayoutPanel1.SuspendLayout();
            foreach (PropertyBox b in m_Boxes)
            {
                b.OnCenterizedButtonClicked -= this.OnPropertyBoxCenterizedButtonClicked;
                b.OnDeleteClicked -= this.OnPropertyBoxDeleteClicked;
            }

            m_Boxes.Clear();
            this.flowLayoutPanel1.Controls.Clear();
            this.flowLayoutPanel1.PerformLayout();

            this.flowLayoutPanel1.Controls.Add(leftButton);
            foreach (LexemeCondition conditem in m_Model.LexemeConds)
            {
                PropertyBox box = new PropertyBox(conditem);
                m_Boxes.Add(box);
                this.flowLayoutPanel1.Controls.Add(box);
                box.OnCenterizedButtonClicked += new EventHandler(this.OnPropertyBoxCenterizedButtonClicked);
                box.OnDeleteClicked += new EventHandler(this.OnPropertyBoxDeleteClicked);
            }
            this.flowLayoutPanel1.Controls.Add(rightButton);

            this.flowLayoutPanel1.ResumeLayout();
            this.ResumeLayout();
            this.PerformLayout();
//            this.Visible = true;
        }

        void ModelChangedHandler(object sender, EventArgs e)
        {
            UpdateView();
        }

        /// <summary>
        /// {^ꂽƂ̏
        /// Ƀ{bNXǉ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void leftButton_Click(object sender, EventArgs e)
        {
            m_Model.InsertLexemeConditionAtLeft();
        }

        private void rightButton_Click(object sender, EventArgs e)
        {
            m_Model.InsertLexemeConditionAtRight();
        }

        /// <summary>
        /// PropertyBoxCenterized ButtoniԂjꂽ̏B
        /// BoxPivot\B
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnPropertyBoxCenterizedButtonClicked(object sender, EventArgs e)
        {
            int offset = 0;
            foreach (PropertyBox b in m_Boxes)
            {
                if (b == sender)
                {
                    b.IsPivot = true;
                    offset = b.Range.Start;
                }
                else
                {
                    b.IsPivot = false;
                }
            }
            if (offset != 0)
            {
                foreach (PropertyBox b in m_Boxes)
                {
                    b.OffsetRange(-offset);
                }
            }
            Invalidate(true);
        }

        /// <summary>
        /// PropertyBox̃CxgʒmɂABox폜B
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnPropertyBoxDeleteClicked(object sender, EventArgs e)
        {
            int index = m_Boxes.IndexOf((PropertyBox)sender);
            m_Model.RemoveAt(index);
        }
    }
}
