using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;

namespace ChaKi
{
    public partial class ContextPanel : Form
    {
        public SentenceContext Model { get; set; }

        public ContextPanel()
        {
            this.Model = new SentenceContext();

            InitializeComponent();
        }

        public void UpdateView()
        {
            Color fg = this.richTextBox1.ForeColor;
            Color bg = this.richTextBox1.BackColor;
            this.richTextBox1.Clear();

            this.richTextBox1.SelectionColor = fg;
            this.richTextBox1.SelectionBackColor = bg;
            foreach (string s in Model.Pre)
            {
                this.richTextBox1.SelectedText = s;
            }
            this.richTextBox1.SelectionColor = Color.Yellow;
            this.richTextBox1.SelectionBackColor = Color.Brown;
            foreach (string s in Model.Center)
            {
                this.richTextBox1.SelectedText = s;
            }
            this.richTextBox1.SelectionColor = fg;
            this.richTextBox1.SelectionBackColor = bg;
            foreach (string s in Model.Post)
            {
                this.richTextBox1.SelectedText = s;
            }
        }
    }
}