using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Drawing;
using ChaKi.Entity.Kwic;
using ChaKi.Entity.Corpora;
using System.Threading;
using System.Drawing.Text;
using System.ComponentModel;
using System.Diagnostics;
using ChaKi.Common;

namespace ChaKi
{
    // Owner-draw DataGridView
    // cf. http://msdn.microsoft.com/ja-jp/library/85kxk29c(VS.80).aspx
    //     http://msdn.microsoft.com/ja-jp/library/hta8z9sz(VS.80).aspx
    //
    public class KwicGrid : DataGridView
    {
        /// <summary>
        /// ViewɑΉtꂽKwic̓eێModel
        /// </summary>
        public KwicList Model
        {
            get { return m_Model; }
        }
        private KwicList m_Model;
        private bool m_bNotify;

        public bool IsSingleLineMode { get; set; }
        public LP L1Tag { get; set; }
        public LP L2Tag { get; set; }

        private const int CUSTOM_CONTENT_HEIGHT = 35;
        private int oldRowIndex = 0;
        private Brush m_ForeBrush;
        private Brush m_ForeBrushSel;
        private Brush m_BackBrush;
        private Brush m_BackBrushSel;
        private Brush m_ForeBrushPivot;
        private Brush m_ForeBrushPivotSel;
        private Pen m_BorderPen;
        private Pen m_BorderPen2;
        private Font m_Font;
        private Font m_Font0;
        private Font m_FontSmall;
        private Font m_FontI;
        private Font m_FontB;
        private Font m_FontBI;
        private Font m_FontBSmall;

        private System.Threading.Timer m_Timer;      // `XV^C}

        // ƎɊǗ\[g
        private DataGridViewColumn m_KwicSortedColumn = null;
        private SortOrder m_KwicSortOrder;

        private const int m_nHeader = 9;
        private static string[] m_HeaderText = new string[9] {
            "Index", "Check", "Corpus", "Char", "Sen",
            "Left", "Center", "Right", "Bib" };
        private static int[] m_HeaderWidth = new int[9] {
            37, 24, 100, 44, 44,
            280, 100, 280, 23 };
        private static DataGridViewColumn[] m_ColumnObjects = new DataGridViewColumn[9] {
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewCheckBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn()
        };

        private int m_LastRow = 0;

        /// <summary>
        /// CurrentsωƂ̐e(MainForm)ւ̒ʒm 
        /// </summary>
        public event CurrentChangedDelegate OnCurrentChanged;
        /// <summary>
        /// Context\w̐e(MainForm)ւ̒ʒm 
        /// </summary>
        public event RequestContextDelegate OnContextRequested;
        /// <summary>
        /// Guide Panel̕\XVʒm 
        /// </summary>
        public event UpdateGuidePanelDelegate OnUpdateGuidePanel;

        // HitTest֌W
        private KwicPortion m_LastHitKwicPortion;
        private Dictionary<Rectangle, Lexeme> m_WordPosMap;


        public KwicGrid()
        {
            m_bNotify = false;
            m_Model = null;

            //@todo: ݒŕύX\ƂKv.
            IsSingleLineMode = false;
            L1Tag = LP.Surface;
            L2Tag = LP.PartOfSpeech;

            // HitTest֌W̕ϐ
            m_LastHitKwicPortion = null;
            m_WordPosMap = new Dictionary<Rectangle, Lexeme>();

            this.InitializeComponent();

        }

        public void SetModel(KwicList model)
        {
            // Model̊蓖ĂUpdateM
            m_Model = (KwicList)model;
            if (m_Model != null)
            {
                m_Model.OnModelChanged += new UpdateKwicListEventHandler(this.ModelChangedHandler);
                // Clear all
                this.Rows.Clear();
                this.RowCount = m_Model.Records.Count;
            }
        }

        private void InitializeComponent()
        {
            this.SuspendLayout();

            // Z̔wiF
            this.RowTemplate.DefaultCellStyle.BackColor = Color.Linen;

            // ̍ݒ肷
            this.RowTemplate.Height = CUSTOM_CONTENT_HEIGHT;

            // ̐ݒ
            this.Columns.AddRange( m_ColumnObjects );

            // wb_̐ݒ
            for (int i = 0; i < m_nHeader; i++)
            {
                this.Columns[i].Name = m_HeaderText[i];
                this.Columns[i].Width = m_HeaderWidth[i];
            }

            // \ɂ@F
            //            this.Columns[0].Visible = false;

            // ̑̐ݒ
            this.BorderStyle = BorderStyle.None;
            this.RowHeadersVisible = false;
            this.BackgroundColor = System.Drawing.SystemColors.ControlDark;
            this.AllowUserToAddRows = false;
            this.EditMode = DataGridViewEditMode.EditProgrammatically;
            this.CellBorderStyle = DataGridViewCellBorderStyle.Single;
            this.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            this.ColumnHeadersDefaultCellStyle.Font = new System.Drawing.Font("Lucida Sans Unicode", 8F);
            this.Columns[5].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight;
            this.GridColor = System.Drawing.SystemColors.Control;
            this.DoubleBuffered = true;

            this.RowCount = 0;

            // Adjust the row heights to accommodate the normal cell content.
            this.AutoResizeRows(DataGridViewAutoSizeRowsMode.AllCellsExceptHeaders);

            // `惊\[X
            m_ForeBrush = new SolidBrush(Color.Black);
            m_ForeBrushSel = new SolidBrush(Color.White);
            m_BackBrush = new SolidBrush(Color.Linen);
            m_BackBrushSel = new SolidBrush(this.DefaultCellStyle.SelectionBackColor);
            m_ForeBrushPivot = new SolidBrush(Color.Red);
            m_ForeBrushPivotSel = new SolidBrush(Color.Khaki);
            m_BorderPen = new Pen(Color.DarkGray);
            m_BorderPen2 = new Pen(Color.White);
            m_Font = new Font("lr oSVbN", 10F, FontStyle.Regular);
            m_Font0 = new Font("Lucida Sans Unicode", 8F, FontStyle.Regular);
            m_FontSmall = new Font("lr oSVbN", 8F, FontStyle.Regular);
            m_FontI = new Font("lr oSVbN", 10F, FontStyle.Italic);
            m_FontB = new Font("lr oSVbN", 10F, FontStyle.Bold);
            m_FontBI = new Font("lr oSVbN", 10F, FontStyle.Italic | FontStyle.Bold);
            m_FontBSmall = new Font("lr oSVbN", 8F, FontStyle.Bold);

            // `XV^C}
            TimerCallback timerDelegate = new TimerCallback(this.OnTimer);
            m_Timer = new System.Threading.Timer(timerDelegate, null, 1000, 1000);

            // Attach handlers to DataGridView events.
            this.ColumnWidthChanged += new DataGridViewColumnEventHandler(kwicView_ColumnWidthChanged);
//            this.RowPrePaint += new DataGridViewRowPrePaintEventHandler(kwicView_RowPrePaint);
//            this.RowPostPaint += new DataGridViewRowPostPaintEventHandler(kwicView_RowPostPaint);
            this.CellPainting += new DataGridViewCellPaintingEventHandler(kwicView_CellPainting);
            this.CurrentCellChanged += new EventHandler(kwicView_CurrentCellChanged);
            this.RowHeightChanged += new DataGridViewRowEventHandler(kwicView_RowHeightChanged);
            this.Resize += new EventHandler(kwicview_Resize);
            this.ColumnHeaderMouseClick += new DataGridViewCellMouseEventHandler(KwicView_ColumnHeaderMouseClick);
            this.MouseMove += new MouseEventHandler(KwicView_MouseMove);
            this.MouseDoubleClick += new MouseEventHandler(KwicView_MouseDoubleClick);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                m_ForeBrush.Dispose();
                m_ForeBrushSel.Dispose();
                m_BackBrush.Dispose();
                m_BackBrushSel.Dispose();
                m_ForeBrushPivot.Dispose();
                m_ForeBrushPivotSel.Dispose();
                m_BorderPen.Dispose();
                m_BorderPen2.Dispose();
                m_Font.Dispose();
                m_Font0.Dispose();
                m_FontSmall.Dispose();
                m_FontI.Dispose();
                m_FontB.Dispose();
                m_FontBI.Dispose();
                m_FontBSmall.Dispose();
                m_Timer.Dispose();
            }
            base.Dispose(disposing);

        }

        /// <summary>
        /// JiLeft,Rightϓj
        /// </summary>
        public void AutoAdjustColumnWidths()
        {
            int clientw = Parent.ClientSize.Width;
            if (this.VerticalScrollBar.Visible)
            {
                clientw -= VerticalScrollBar.Size.Width;
            }

            if (this.Columns["Center"].Width < 50)
            {
                this.Columns["Center"].Width = 50;
            }
            int w_total = 10;
            foreach (DataGridViewColumn col in this.Columns)
            {
                w_total += col.Width;
            }
            int w1 = this.Columns["Left"].Width + this.Columns["Right"].Width;
            int w_lr = (clientw - (w_total - w1)) / 2;

            if (w_lr > 0)
            {
                this.Columns["Left"].Width = w_lr;
                this.Columns["Right"].Width = w_lr;
            }
        }

        /// <summary>
        /// JiLeft=0,Center=0ƂāARightő剻j
        /// </summary>
        public void LeftAdjustColumnWidths()
        {
            int clientw = Parent.ClientSize.Width;
            if (this.VerticalScrollBar.Visible)
            {
                clientw -= VerticalScrollBar.Size.Width;
            } 
            
            this.Columns["Right"].Width += (this.Columns["Left"].Width + this.Columns["Center"].Width);
            this.Columns["Left"].Width = 0;
            this.Columns["Center"].Width = 0;

            int w_total = 10;
            foreach (DataGridViewColumn col in this.Columns)
            {
                w_total += col.Width;
            }
            int adj = clientw - w_total;
            this.Columns["Right"].Width += adj;
        }

        /// <summary>
        /// KWIC\eNA
        /// </summary>
        public void DeleteAll()
        {
            if (m_Model != null)
            {
                m_Model.DeleteAll();
            }
        }

        public void ShiftHilight(int shift)
        {
            if (m_Model != null)
            {
                m_Model.SetHilight(shift);
            }
        }

        private void kwicView_RowPrePaint(object sender, DataGridViewRowPrePaintEventArgs e)
        {
#if false
            // Do not automatically paint the focus rectangle.
            e.PaintParts &= ~DataGridViewPaintParts.Focus;

            // Calculate the bounds of the row.
            Rectangle rowBounds = new Rectangle(
                        this.RowHeadersWidth,
                        e.RowBounds.Top,
                        this.Columns.GetColumnsWidth(DataGridViewElementStates.Visible) - this.HorizontalScrollingOffset + 1,
                        e.RowBounds.Height);

            // ĨobNOEh`
            Brush backbrush = null;
            if ((e.State & DataGridViewElementStates.Selected) == DataGridViewElementStates.Selected)
            {
                using (backbrush = new System.Drawing.Drawing2D.LinearGradientBrush(rowBounds,
                        this.DefaultCellStyle.SelectionBackColor,
                        e.InheritedRowStyle.ForeColor,
                        System.Drawing.Drawing2D.LinearGradientMode.Vertical))
                {
                    e.Graphics.FillRectangle(backbrush, rowBounds);
                }
            }
#endif
        }

        private void kwicView_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
#if false
            // s̋Eʒu߂
            Rectangle rowBounds = new Rectangle(
                this.RowHeadersWidth,
                e.RowBounds.Top,
                this.Columns.GetColumnsWidth(DataGridViewElementStates.Visible) - this.HorizontalScrollingOffset + 1,
                e.RowBounds.Height);


            if (this.CurrentCellAddress.Y == e.RowIndex)
            {
                // Paint the focus rectangle.
                e.DrawFocus(rowBounds, true);
            }
#endif
        }

        private void kwicView_CellPainting(object sender, DataGridViewCellPaintingEventArgs e)
        {
            if (m_Model == null)
            {
                return;
            }
            // `悵悤ƂĂsɑModel Record݂邩`FbN
            if (e.ColumnIndex < 0 || e.RowIndex < 0 || e.RowIndex >= m_Model.Records.Count)
            {
                return;
            }
            // `̈߂
            Rectangle rect = e.CellBounds;

            Graphics g = e.Graphics;
            // eLXg̕Lɂ
            g.TextRenderingHint = TextRenderingHint.ClearTypeGridFit;

            bool bSel = ((e.State & DataGridViewElementStates.Selected) == DataGridViewElementStates.Selected);

            // wihԂ
            Brush backBrush;
            if (bSel)
            {
                backBrush = m_BackBrushSel;
            }
            else
            {
                backBrush = m_BackBrush;
            }
            g.FillRectangle(backBrush, rect);
            g.DrawLine(m_BorderPen, rect.Right-1, rect.Top, rect.Right-1, rect.Bottom);

            // JX^}CYƃftHg`Ƃ̊Ԃׂ̍
            if (bSel)
            {
                g.DrawLine(m_BorderPen2, rect.Left, rect.Bottom - 1, rect.Right, rect.Bottom - 1);
            }
            if (e.ColumnIndex == 2)
            {
                g.DrawLine(m_BorderPen, rect.Left, rect.Top, rect.Left, rect.Bottom);
            }

            // Z̈NbsÖɐݒ肷
            RectangleF oldClip = e.Graphics.ClipBounds;
            g.SetClip(rect);

            // JƂɈقȂ`֐Ăяo
            string s;
            bool handled = true;
            switch (e.ColumnIndex)
            {
                case 0:
                    s = String.Format("{0}", m_Model.Records[e.RowIndex].ID);
                    DrawSimpleColumn(s, g, bSel, rect, StringAlignment.Far);
                    break;
                case 1:
                    // default handler֓n
                    handled = false;
                    break;
                case 2:
                    s = m_Model.Records[e.RowIndex].Crps.Name;
                    DrawSimpleColumn(s, g, bSel, rect, StringAlignment.Near);
                    break;
                case 3:
                    s = String.Format("{0}", m_Model.Records[e.RowIndex].CharPos);
                    DrawSimpleColumn(s, g, bSel, rect, StringAlignment.Far);
                    break;
                case 4:
                    s = String.Format("{0}", m_Model.Records[e.RowIndex].SenPos);
                    DrawSimpleColumn(s, g, bSel, rect, StringAlignment.Far);
                    break;
                case 5:  // Left
                    DrawKwicPortion(-1, m_Model.Records[e.RowIndex].Left, g, bSel, rect, false);
                    break;
                case 6:  // Center
                    DrawKwicPortion(0, m_Model.Records[e.RowIndex].Center, g, bSel, rect, false);
                    break;
                case 7:
                    DrawKwicPortion(1, m_Model.Records[e.RowIndex].Right, g, bSel, rect, false);
                    break;
            }

            // NbsÖZbg
            g.SetClip(oldClip);

            e.Handled = handled;
        }

        private void DrawSimpleColumn(string str, Graphics g, bool bSel, Rectangle rect, StringAlignment alignment)
        {
            // IEI̕F肷
            Font font1 = null;  // Psڕ`̂߂̃tHg
            Font font2 = null;  // Qsڕ`̂߂̃tHg
            Brush br = null;    // F

            GetWordFontAndBrush(bSel, null, ref font1, ref font2, ref br);
            g.DrawString(str, m_Font0, br, rect, 
                new StringFormat()
                {
                    Alignment = alignment,
                    LineAlignment = StringAlignment.Center,
                    Trimming = StringTrimming.EllipsisWord
                });
        }

        /// <summary>
        /// ^ꂽ̈KwicPortion`悷
        /// </summary>
        /// <param name="lcr">Left:-1, Center:0, Right:1</param>
        /// <param name="kp"></param>
        /// <param name="g"></param>
        /// <param name="bSel"></param>
        /// <param name="rect"></param>
        /// <param name="fmt"></param>
        private void DrawKwicPortion(int lcr, KwicPortion kp, Graphics g, bool bSel, Rectangle rect, bool recordPos)
        {
            bool nullDraw = (recordPos) ? true : false;
            double offset;

            switch (lcr)
            {
                case -1:    // Left Portion
                    offset = DrawKwicPortion2(kp, g, bSel, rect, true, false);
                    rect.X = rect.X + rect.Width - (int)offset;
                    DrawKwicPortion2(kp, g, bSel, rect, nullDraw, recordPos);
                    break;
                case 0:     // Center Portion
                    offset = DrawKwicPortion2(kp, g, bSel, rect, true, false);
                    rect.X = rect.X + (int)((rect.Width - offset) / 2.0);
                    DrawKwicPortion2(kp, g, bSel, rect, nullDraw, recordPos);
                    break;
                case 1:     // Right Portion
                    DrawKwicPortion2(kp, g, bSel, rect, nullDraw, recordPos);
                    break;
            }
        }

        /// <summary>
        /// ^ꂽ̈KwicPortion`悷.
        /// 
        /// `TCY𑪂ꍇFbNullDraw=true, bRecordPos =false
        /// ۂɕ`悷ꍇFbNullDraw=false, bRecordPos=false
        /// ëʒuHashꍇFbNullDraw=true, bRecordPos=true
        /// </summary>
        /// <param name="kp"></param>
        /// <param name="g"></param>
        /// <param name="bSel"></param>
        /// <param name="rect"></param>
        /// <param name="bNullDraw">ʕ`֐̂݌ĂяoȂ</param>
        /// <param name="bRecordPos">̈ʒuL^</param>
        /// <returns></returns>
        private double DrawKwicPortion2(KwicPortion kp, Graphics g, bool bSel, Rectangle rect, bool bNullDraw, bool bRecordPos)
        {
            // IEI̕F肷
            Font font1 = null;  // Psڕ`̂߂̃tHg
            Font font2 = null;  // Qsڕ`̂߂̃tHg
            Brush br = null;    // F

            double cur_x = rect.X;
            double y = rect.Y + 2.0;

            foreach (KwicWord word in kp.Words)
            {
                GetWordFontAndBrush(bSel, word, ref font1, ref font2, ref br);

                string s1 = "";
                string s2 = "";
                if (word.Lex != null)
                {
                    s1 = word.Lex.GetStringPropertyShort(this.L1Tag);
                    s2 = word.Lex.GetStringPropertyShort(this.L2Tag);
                }
                else if (word.Text != null)
                {
                    s1 = word.Text;
                }
                SizeF sz1 = g.MeasureString(s1, font1);
                SizeF sz2 = g.MeasureString(s2, font2);
                double width = (double)sz1.Width;
                if (!this.IsSingleLineMode)
                {
                    width = Math.Max(width, (double)sz2.Width) + 5.0;
                }
                double x1 = cur_x + (width - (double)sz1.Width) / 2.0;
                double x2 = cur_x + (width - (double)sz2.Width) / 2.0;

                // `tOtruȅꍇ̂݁Aۂɕ`s
                if (!bNullDraw)
                {
                    g.DrawString(s1, font1, br, (float)x1, (float)y);
                    if (!this.IsSingleLineMode)
                    {
                        g.DrawString(s2, font2, br, (float)x2, (float)(y + sz1.Height + 2));
                    }
                }
                // RecordPostrueȂA`̈LexemeL^.
                if (bRecordPos)
                {
                    Rectangle wordRect = new Rectangle((int)cur_x, (int)y, (int)width - 1, rect.Height);
                    m_WordPosMap.Add(wordRect, word.Lex);
                }
                cur_x += (width + 5.0);
            }
            // `̑S̕Ԃ
            return cur_x - rect.X;
        }

        /// <summary>
        /// ̕`ɎgptHgƐF肷
        /// </summary>
        /// <param name="bSel"></param>
        /// <param name="word">nullłBword^ꍇ͑ɂtHgEFXɏڍׂɌ肷</param>
        /// <param name="font1"></param>
        /// <param name="font2"></param>
        /// <param name="foreBrush"></param>
        private void GetWordFontAndBrush(bool bSel, KwicWord word, ref Font font1, ref Font font2, ref Brush foreBrush)
        {
            int at = 0;
            if (word != null) {
                at = word.ExtAttr;
            }
            // tHg
            if ((at & KwicWord.KWA_PIVOT) != 0 || (at & KwicWord.KWA_HILIGHT) != 0)
            {
                if ((at & KwicWord.KWA_COMPWORD) != 0)
                {
                    font1 = m_FontBI;
                }
                else
                {
                    font1 = m_FontB;
                }
                font2 = m_FontBSmall;
            }
            else
            {
                if ((at & KwicWord.KWA_COMPWORD) != 0)
                {
                    font1 = m_FontI;
                }
                else
                {
                    if (word == null)
                    {
                        font1 = m_Font0;
                    }
                    else
                    {
                        font1 = m_Font;
                    }
                }
                font2 = m_FontSmall;
            }
            // `F
            if ((at & KwicWord.KWA_PIVOT) != 0)
            {
                // PIVOT͏ɐԂŕ`
                if (bSel)
                {
                    foreBrush = m_ForeBrushPivotSel;
                }
                else
                {
                    foreBrush = m_ForeBrushPivot;
                }
            }
            else
            {
                if (bSel)
                {
                    foreBrush = m_ForeBrushSel;
                }
                else
                {
                    foreBrush = m_ForeBrush;
                }
            }
        }


        /// <summary>
        /// [UJ蓮ŕύXɃRg[Iɍĕ`悷
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void kwicView_ColumnWidthChanged(object sender, DataGridViewColumnEventArgs e)
        {
            this.Invalidate();
        }

        /// <summary>
        /// [UJgZύXƂɃZĕ`悷B
        /// tH[JXlp`̕\tbV邽߂ɕKvB
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void kwicView_CurrentCellChanged(object sender, EventArgs e)
        {
            if (oldRowIndex != -1)
            {
                this.InvalidateRow(oldRowIndex);
            }
            oldRowIndex = this.CurrentCellAddress.Y;

            if (this.CurrentRow != null)
            {
                // Jgsς̂MainFormɒʒm.
                if (this.CurrentRow.Index != m_LastRow)
                {
                    m_LastRow = this.CurrentRow.Index;
                    if (m_LastRow >= 0 && m_LastRow < m_Model.Records.Count)
                    {
                        KwicItem ki = m_Model.Records[m_LastRow];
                        if (ki != null && OnCurrentChanged != null)
                        {
                            OnCurrentChanged.BeginInvoke(ki.Crps, ki.SenPos, null, null);
                        }
                    }
                }
            }
        }

        // Adjusts the padding when the user changes the row height so that 
        // the normal cell content is fully displayed and any extra
        // height is used for the content that spans multiple columns.
        void kwicView_RowHeightChanged(object sender, DataGridViewRowEventArgs e)
        {
#if false
            // Calculate the new height of the normal cell content.
            Int32 preferredNormalContentHeight =
                e.Row.GetPreferredHeight(e.Row.Index,
                DataGridViewAutoSizeRowMode.AllCellsExceptHeader, true) -
                e.Row.DefaultCellStyle.Padding.Bottom;

            // Specify a new padding.
            Padding newPadding = e.Row.DefaultCellStyle.Padding;
            newPadding.Bottom = e.Row.Height - preferredNormalContentHeight;
            e.Row.DefaultCellStyle.Padding = newPadding;
#endif
        }

        /// <summary>
        /// Rg[TCYύXꂽƂɁA[IɃJύXāA
        /// XN[͈͂̍ČvZB
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void kwicview_Resize(object sender, EventArgs e)
        {
            this.Columns[0].Width = this.Columns[0].Width + 1;
            this.Columns[0].Width = this.Columns[0].Width - 1;
        }

        /// <summary>
        /// }EXړꍇAsςĂ΁A̍s̋[`s
        /// Lexeme->Rectanglẽ}bsOČvZ.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void KwicView_MouseMove(object sender, MouseEventArgs e)
        {
            if (m_Model == null)
            {
                return;
            }
            HitTestInfo htinfo = this.HitTest(e.X, e.Y);
            if (htinfo.RowIndex >= 0)
            {
                int row = htinfo.RowIndex;
                int col = htinfo.ColumnIndex;
                KwicPortion kp = null;
                if (row < 0 || row >= m_Model.Records.Count) {
                    return;
                }
                switch (col) {
                    case 5:
                        kp = m_Model.Records[row].Left;
                        break;
                    case 6:
                        kp = m_Model.Records[row].Center;
                        break;
                    case 7:
                        kp = m_Model.Records[row].Right;
                        break;
                }
                if (kp == null)
                {
                    return;
                }
                if (kp != m_LastHitKwicPortion)
                {
                    m_LastHitKwicPortion = kp;
                    Rectangle rect = this.GetCellDisplayRectangle(col, row, false);
                    m_WordPosMap.Clear();
                    DrawKwicPortion(col-6, kp, this.CreateGraphics(), false, rect, true);
                }
                // ۂɊeWordRectangleƂHitTests
                Lexeme lex = null;
                foreach (KeyValuePair<Rectangle, Lexeme> pair in m_WordPosMap)
                {
                    if (pair.Key.Contains(e.Location))
                    {
                        lex = pair.Value;
                        break;
                    }
                }
                if (lex != null && this.OnUpdateGuidePanel != null)
                {
                    this.OnUpdateGuidePanel(lex);
                }
            }
        }

       

        /// <summary>
        /// wb_NbNꂽAe\[g
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void KwicView_ColumnHeaderMouseClick(object sender, DataGridViewCellMouseEventArgs e)
        {
            DataGridViewColumn newColumn = this.Columns[e.ColumnIndex];
            DataGridViewColumn oldColumn = this.m_KwicSortedColumn;
            SortOrder direction;

            // oldColumnnullȂDataGridView̓\[gĂȂB
            if (oldColumn != null)
            {
                // JtŃ\[g
                if (oldColumn == newColumn && m_KwicSortOrder == SortOrder.Ascending)
                {
                    direction = SortOrder.Descending;
                }
                else
                {
                    // ʂ̃J\[gB݂SortGlyphB
                    direction = SortOrder.Ascending;
                    oldColumn.HeaderCell.SortGlyphDirection = SortOrder.None;
                }
            }
            else
            {
                direction = SortOrder.Ascending;
            }

            // \[gs
            m_Model.Sort(newColumn.Index, (direction == SortOrder.Ascending));
            m_KwicSortedColumn = newColumn;
            m_KwicSortOrder = direction;
            newColumn.HeaderCell.SortGlyphDirection = direction;
        }

        /// <summary>
        /// s_uNbNꂽAReNXg擾E\
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void KwicView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (this.OnContextRequested != null)
            {
                HitTestInfo htinfo = this.HitTest(e.X, e.Y);
                if (htinfo.RowIndex >= 0)
                {
                    int row = htinfo.RowIndex;
                    if (row < 0 || row >= m_Model.Records.Count)
                    {
                        return;
                    }
                    this.OnContextRequested(m_Model, row);
                }
            }
        }

        delegate void SetCountDelegate(int count);
        public void SetCount(int count)
        {
            if (count == 0)
            {
                // Clear all
                this.Rows.Clear();
            }
            else
            {
                this.RowCount = count;
            }
        }

        void OnTimer(object obj)
        {
            if (m_Model == null)
            {
                return;
            }
            if (m_bNotify)
            {
                try
                {
                    this.Invoke(new SetCountDelegate(SetCount), new object[] { m_Model.Records.Count });
                }
                catch (Exception e)
                {
                    Debug.WriteLine(e);
                }
                m_bNotify = false;
            }
        }

        void ModelChangedHandler(object sender, UpdateKwicListEventArgs e)
        {
            m_bNotify = true;
            if (e.Redraw)
            {
                this.Invalidate();
            }
        }

        public Corpus GetCurrentCorpus()
        {
            if (m_Model == null)
            {
                return null;
            }
            int idx = this.CurrentRow.Index;
            if (idx < 0 || idx >= m_Model.Records.Count)
            {
                return null;
            }
            return m_Model.Records[idx].Crps;
        }

        public int GetCurrentSentenceID()
        {
            if (m_Model == null)
            {
                return -1;
            }
            int idx = this.CurrentRow.Index;
            if (idx < 0 || idx >= m_Model.Records.Count)
            {
                return -1;
            }
            return m_Model.Records[idx].SenPos;
        }

        public int GetCurrentCenterWordID()
        {
            if (m_Model == null)
            {
                return -1;
            }
            int idx = this.CurrentRow.Index;
            if (idx < 0 || idx >= m_Model.Records.Count)
            {
                return -1;
            }
            return m_Model.Records[idx].Left.Words.Count;
        }

    }
}
