﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using DependencyEdit;
using ChaKi.Entity.Kwic;
using ChaKi.Entity.Corpora;
using ChaKi.Common;

namespace ChaKi
{
    public class KwicView : SplitContainer, IChaKiView
    {
        private KwicGrid kwicGrid;
        private DepEditControl depEdit;

        /// <summary>
        /// Current行が変化したときの親(MainForm)への通知
        /// （子Viewからの中継）
        /// </summary>
        public event CurrentChangedDelegate OnCurrentChanged;
        /// <summary>
        /// Context表示指示時の親(MainForm)への通知 
        /// （子Viewからの中継）
        /// </summary>
        public event RequestContextDelegate OnContextRequested;
        /// <summary>
        /// Guide Panelの表示更新通知 
        /// （子Viewからの中継）
        /// </summary>
        public event UpdateGuidePanelDelegate OnUpdateGuidePanel;

        public KwicView()
        {
            this.kwicGrid = new KwicGrid();
            this.depEdit = new DepEditControl();

            // kwicGrid
            this.kwicGrid.Enabled = true;
            this.kwicGrid.Location = new System.Drawing.Point(0, 0);
            this.kwicGrid.Name = "kwicView";
            this.kwicGrid.Size = new System.Drawing.Size(400, 200);
            this.kwicGrid.TabIndex = 0;
            this.kwicGrid.Dock = DockStyle.Fill;
            // 
            // depEdit
            // 
            this.depEdit.AutoScroll = true;
            this.depEdit.AutoSizeMode = System.Windows.Forms.AutoSizeMode.GrowAndShrink;
            this.depEdit.Dock = System.Windows.Forms.DockStyle.Fill;
            this.depEdit.Font = new System.Drawing.Font("Lucida Sans Unicode", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.depEdit.Location = new System.Drawing.Point(0, 0);
            this.depEdit.Name = "depView";
            this.depEdit.Size = new System.Drawing.Size(247, 94);
            this.depEdit.TabIndex = 0;
            // Add controls to splitter
            this.Panel1.Controls.Add(this.kwicGrid);
            this.Panel2.Controls.Add(this.depEdit);

            this.SplitterMoved += new SplitterEventHandler(this.splitContainer1_SplitterMoved);

            // KwicGridからのCallback（MainFormへ中継される）
            this.kwicGrid.OnUpdateGuidePanel += new UpdateGuidePanelDelegate(this.UpdateGuidePanelHandler);
            this.kwicGrid.OnCurrentChanged += new CurrentChangedDelegate(this.CurrentChangedHandler);
            this.kwicGrid.OnContextRequested += new RequestContextDelegate(this.RequestContextHandler);
        }

        private void UpdateGuidePanelHandler(Lexeme lex)
        {
            if (this.OnUpdateGuidePanel != null) OnUpdateGuidePanel(lex);
        }
        private void CurrentChangedHandler(Corpus cps, int senid)
        {
            if (this.OnCurrentChanged != null) OnCurrentChanged(cps, senid);
        }
        private void RequestContextHandler(KwicList list, int row)
        {
            if (this.OnContextRequested != null) OnContextRequested(list, row);
        }



        public void SetModel(object model)
        {
            if (model != null && !(model is KwicList))
            {
                throw new ArgumentException("Assigning invalid model to KwicPanel");
            }
            this.kwicGrid.SetModel((KwicList)model);
        }

        public void SetVisible(bool f)
        {
            this.Visible = f;
        }

        public void AutoAdjustColumnWidths()
        {
            this.kwicGrid.AutoAdjustColumnWidths();
        }

        public void LeftAdjustColumnWidths()
        {
            this.kwicGrid.LeftAdjustColumnWidths();
        }

        public Corpus GetCurrentCorpus()
        {
            return this.kwicGrid.GetCurrentCorpus();
        }

        public int GetCurrentSentenceID()
        {
            return this.kwicGrid.GetCurrentSentenceID();
        }

        public int GetCurrentCenterWordID()
        {
            return this.kwicGrid.GetCurrentCenterWordID();
        }

        public void DeleteAll()
        {
            this.kwicGrid.DeleteAll();
        }

        public void ShiftHilight(int shift)
        {
            this.kwicGrid.ShiftHilight(shift);
        }

        public void BeginSentenceEdit(Corpus c, int i, int j)
        {
            this.depEdit.BeginSentenceEdit(c, i, j);
        }

        private void splitContainer1_SplitterMoved(object sender, SplitterEventArgs e)
        {
            if (this.Panel1.Height < 50)
            {
                this.Panel1Collapsed = true;
                this.Panel2Collapsed = false;
            }
            else if (this.Panel2.Height < 50)
            {
                this.Panel2Collapsed = true;
                this.Panel1Collapsed = false;
            }
        }

    }
}
