﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using Crownwood.DotNetMagic.Docking;
using ChaKi.Options;
using ChaKi.Entity.Search;

namespace ChaKi
{
    partial class MainForm
    {
        private void OnFileNew(object sender, EventArgs e)
        {
        }

        private void OnFileOpen(object sender, EventArgs e)
        {
        }

        private void OnFileSave(object sender, EventArgs e)
        {
            OnFileSaveAs(sender, e);
        }

        private void OnFileSaveAs(object sender, EventArgs e)
        {
            FileDialog dlg = new SaveFileDialog();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                this.Save(dlg.FileName, null);
            }
        }

        private void OnFilePrint(object sender, EventArgs e)
        {
        }

        private void OnFileExit(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnEditCopy(object sender, EventArgs e)
        {
        }

        private void OnEditCut(object sender, EventArgs e)
        {
        }

        private void OnEditPaste(object sender, EventArgs e)
        {
        
        }

        private void OnEditDeleteAll(object sender, EventArgs e)
        {
            this.kwicView.DeleteAll();
        }
        
        private void OnViewToolbar(object sender, EventArgs e)
        {
            this.toolStrip.Visible = !this.toolStrip.Visible;
        }

        private void OnViewToolbarUpdate(object sender, EventArgs e)
        {
            this.UICViewToolbarToolStripMenuItem.Checked = this.toolStrip.Visible;
        }

        private void OnViewStatusBar(object sender, EventArgs e)
        {
            this.statusStrip1.Visible = !this.statusStrip1.Visible;
        }

        private void OnViewStatusBarUpdate(object sender, EventArgs e)
        {
            this.UICViewStatusBarToolStripMenuItem.Checked = this.statusStrip1.Visible;
        }

        private void OnViewSearchPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.condPanelContainer);
        }

        private void OnViewSearchPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewSearchPanelToolStripMenuItem.Checked = this.condPanelContainer.Visible;
        }

        private void OnViewHistoryPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.historyGuidePanelContainer);
        }

        private void OnViewHistoryPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewHistoryPanelToolStripMenuItem.Checked = this.historyGuidePanelContainer.Visible;
        }

        private void OnViewCommandPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.commandPanelContainer);
        }

        private void OnViewCommandPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewCommandPanelToolStripMenuItem.Checked = this.commandPanelContainer.Visible;
        }

        private void OnViewContextPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.contextPanelContainer);
        }

        private void OnViewContextPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewContextPanelToolStripMenuItem.Checked = this.contextPanelContainer.Visible;
        }

        private void OnViewGuidePanel(object sender, EventArgs e)
        {
            SwitchVisible(this.guidePanelContainer);
        }

        private void OnViewGuidePanelUpdate(object sender, EventArgs e)
        {
            this.UICViewGuidePanelToolStripMenuItem.Checked = this.guidePanelContainer.Visible;
        }

        private void OnViewDependencyToolbar(object sender, EventArgs e)
        {
            //@todo : not implemented yet
        }

        private void OnViewDependencyToolbarUpdate(object sender, EventArgs e)
        {
            //@todo : not implemented yet
            this.UICViewDependencyToolbarToolStripMenuItem.Checked = false;
            this.UICViewDependencyToolbarToolStripMenuItem.Enabled = false;
        }

        private void OnViewKwicListView(object sender, EventArgs e)
        {
            this.kwicView.Panel1Collapsed = false;
            this.kwicView.Panel2Collapsed = true;
        }

        private void OnViewDependencyTreeView(object sender, EventArgs e)
        {
            this.kwicView.Panel1Collapsed = true;
            this.kwicView.Panel2Collapsed = false;
        }

        private void OnViewSplitView(object sender, EventArgs e)
        {
            // Splitter Viewを分割する
            this.kwicView.Panel1Collapsed = false;
            this.kwicView.Panel2Collapsed = false;

            int h = this.kwicView.Height / 2;
            this.kwicView.SplitterDistance = h;
        }

        private void OnViewAutoAdjustRowWidth(object sender, EventArgs e)
        {
            this.kwicView.AutoAdjustColumnWidths();
        }

        private void OnViewAdjustRowWidthToTheLeft(object sender, EventArgs e)
        {
            this.kwicView.LeftAdjustColumnWidths();
        }

        private void OnSearchSelectCorpus(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 0;
        }

        private void OnSearchSelectCorpusUpdate(object sender, EventArgs e)
        {
            this.UICSearchSelectCorpusToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 0);
        }

        private void OnSearchSetSearchFilters(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 1;
        }

        private void OnSearchSetSearchFiltersUpdate(object sender, EventArgs e)
        {
            this.UICSearchSetSearchFiltersToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 1);
        }

        private void OnSearchStringSearchSettings(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 2;
        }

        private void OnSearchStringSearchSettingsUpdate(object sender, EventArgs e)
        {
            this.UICSearchStringSearchSettingsToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 2);
        }

        private void OnSearchTagSearchSettings(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 3;
        }

        private void OnSearchTagSearchSettingsUpdate(object sender, EventArgs e)
        {
            this.UICSearchTagSearchSettingsToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 3);
        }

        private void OnSearchDependencySearchSettings(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 4;
        }

        private void OnSearchDependencySearchSettingsUpdate(object sender, EventArgs e)
        {
            this.UICSearchDependencySearchSettingsToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 4);
        }

        private void OnSearchCollocationSettings(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 5;
        }

        private void OnSearchCollocationSettingsUpdate(object sender, EventArgs e)
        {
            this.UICSearchCollocationSettingsToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 5);
        }

        private void OnSearchBeginSearch(object sender, EventArgs e)
        {
            BeginSearchHandler();
        }

        private void OnSearchBeginSearchUpdate(object sender, EventArgs e)
        {
            this.UICSearchBeginSearchToolStripMenuItem.Enabled = this.commandPanel.CanBeginSearch;
        }

        private void OnFormatShiftPivotLeft(object sender, EventArgs e)
        {
            SearchHistory hist = this.historyGuidePanel.Current;
            if (hist == null) return;
            hist.Shift(-1);

            // TagCondもシフトする
            // History中の条件とCurrentSearchCondtiionsとはインスタンスが異なるので注意
            SearchConditions cond = this.m_Model.CurrentSearchConditions;
            if (cond != null && cond.TagCond != null)
            {
                cond.TagCond.Shift(-1);
            }
        }

        private void OnFormatShiftPivotRight(object sender, EventArgs e)
        {
            SearchHistory hist = this.historyGuidePanel.Current;
            if (hist == null) return;
            hist.Shift(1);

            // TagCondもシフトする
            // History中の条件とCurrentSearchCondtiionsとはインスタンスが異なるので注意
            SearchConditions cond = this.m_Model.CurrentSearchConditions;
            if (cond != null && cond.TagCond != null)
            {
                cond.TagCond.Shift(1);
            }
        }

        private void OnFormatHilightPreviousWord(object sender, EventArgs e)
        {
            this.kwicView.ShiftHilight(-1);
        }

        private void OnFormatHilightNextWord(object sender, EventArgs e)
        {
            this.kwicView.ShiftHilight(1);
        }

        private void OnToolsCreateSQLiteCorpus(object sender, EventArgs e)
        {
            CreateSQLiteCorpus dlg = new CreateSQLiteCorpus();
            dlg.ShowDialog();
            dlg.Dispose();
        }

        private void OnToolsCreateMySQLCorpus(object sender, EventArgs e)
        {
            DBLogin dlg = new DBLogin();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                CreateMySQLCorpus dlg2 = new CreateMySQLCorpus();
                dlg2.DBMS = dlg.DBMS;
                dlg2.Server = dlg.Server;
                dlg2.User = dlg.User;
                dlg2.Password = dlg.Password;
                dlg2.DatabaseCandidates = dlg.Databases;
                dlg2.ShowDialog();
                dlg2.Dispose();
            }
        }

        private void OnOptionsSettings(object sender, EventArgs e)
        {
            OptionDialog dlg = new OptionDialog();
            if (dlg.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                //@ todo
            }
        }

        private void OnHelpAbout(object sender, EventArgs e)
        {
            AboutChaKiDialog dlg = new AboutChaKiDialog();
            dlg.ShowDialog();
            dlg.Dispose();
        }

        
    }
}
