using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Crownwood.DotNetMagic.Docking;
using Crownwood.DotNetMagic.Common;
using Crownwood.DotNetMagic.Forms;

using ChaKi.Common;
using ChaKi.UICommands;
using System.IO;
using ChaKi.Entity.Settings;
using DependencyEdit;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Kwic;
using ChaKi.Entity.Search;

namespace ChaKi
{
    public delegate void BeginSearchDelegate();

    public partial class MainForm : DotNetMagicForm
    {
        #region private members
        private DockingManager dockingManager;
        private Content condPanelContainer;
        private Content commandPanelContainer;
        private Content contextPanelContainer;
        private Content guidePanelContainer;
        private Content historyGuidePanelContainer;
        private ConditionsPanel condPanel;
        private CommandPanel commandPanel;
        private ContextPanel contextPanel;
        private GuidePanel guidePanel;
        private HistoryGuidePanel historyGuidePanel;

        // FormɑΉBModelIuWFNg
        // Form̏LeqEBhÉAModel̈ꕔ蓖ĂAUpdateʒmB
        private ChaKiModel m_Model;

        private string m_DockStateFile;

        #endregion


        public MainForm()
        {
            InitializeComponent();

            Program.MainForm = this;
            m_Model = new ChaKiModel();
            m_Model.Initialize();

            #region create views
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MainForm));

            // Create Views
            this.kwicView.Dock = DockStyle.Fill;
            this.wordListView.Dock = DockStyle.Fill;

            // Ԃŕ\View
            this.ChangeView(SearchType.StringSearch);

            this.ResumeLayout();
            #endregion

            #region create docking panels
            // Create Docking Panels
            condPanel = new ConditionsPanel(m_Model.CurrentSearchConditions);
            contextPanel = new ContextPanel();
            guidePanel = new GuidePanel();
            commandPanel = new CommandPanel();
            historyGuidePanel = new HistoryGuidePanel(m_Model.History);

            this.Style = VisualStyle.Office2007Silver;
            this.dockingManager = new DockingManager(toolStripContainer1.ContentPanel, this.Style);
            condPanel.Style = this.Style;

            dockingManager.CaptionFont = new Font("Arial", 7.5F);
            dockingManager.AllowSideCaptions = true;

            // Hook into the events generated by the docking manager
            //            dockingManager.ContextMenu += new DockingManager.ContextMenuHandler(OnContextMenu);

            // Ensure correct inner and outer values for correct window positioning
            dockingManager.InnerControl = this.kwicView;

            // Setup custom config handling
            dockingManager.SaveCustomConfig += new DockingManager.SaveCustomConfigHandler(OnSaveConfig);
            dockingManager.LoadCustomConfig += new DockingManager.LoadCustomConfigHandler(OnLoadConfig);

            // Create the initial starting docking windows
            // Create a new docking Content instance with our new ExampleForm
            WindowContent wc;
            // Upper (default) Docking Panels
            condPanelContainer = dockingManager.Contents.Add(condPanel, "Search Conditions");
            condPanelContainer.FloatingSize = new Size(800, 150);
            wc = dockingManager.AddContentWithState(condPanelContainer, State.DockTop) as WindowContent;

            commandPanelContainer = dockingManager.Contents.Add(commandPanel, "Command");
            commandPanelContainer.FloatingSize = new Size(200, 150);
            dockingManager.AddContentToZone(commandPanelContainer, wc.ParentZone, 1);

            historyGuidePanelContainer = dockingManager.Contents.Add(historyGuidePanel, "History");
            historyGuidePanelContainer.FloatingSize = new Size(200, 150);
            dockingManager.AddContentToZone(historyGuidePanelContainer, wc.ParentZone, 2);

            // Lower (default) Docking Panels
            contextPanelContainer = dockingManager.Contents.Add(contextPanel, "Context");
            contextPanelContainer.FloatingSize = new Size(800, 150);
            wc = dockingManager.AddContentWithState(contextPanelContainer, State.DockBottom) as WindowContent;

            guidePanelContainer = dockingManager.Contents.Add(guidePanel, "Guide");
            guidePanelContainer.FloatingSize = new Size(200, 150);
            dockingManager.AddContentToZone(guidePanelContainer, wc.ParentZone, 1);

            m_DockStateFile = Program.SettingDir + @"\DockState.xml";
            try
            {
                dockingManager.LoadConfigFromFile(m_DockStateFile);
            }
            catch (FileNotFoundException)
            {
            }
            catch (ArgumentException)
            {
                MessageBox.Show("Could not restore docking positions.  Resetting.");
            }

            #endregion

            #region UICommando^
            //
            // AvP[ṼR}hǗJjÝA
            // ChaKi.UICommandsTutH_ɑ݂UICommandNXsĂ
            // cf. http://geekswithblogs.net/willemf/archive/2007/06/05/113005.aspx
            //
            UICommand uc;
            UICommand.Commands.Add((uc = new UICommand(this, "FileNew")));
            UICommand.Commands.Add((uc = new UICommand(this, "FileOpen")));
            UICommand.Commands.Add((uc = new UICommand(this, "FileSave")));
            UICommand.Commands.Add((uc = new UICommand(this, "FileSaveAs")));
            UICommand.Commands.Add((uc = new UICommand(this, "FileExit")));

            UICommand.Commands.Add((uc = new UICommand(this, "EditCopy")));
            UICommand.Commands.Add((uc = new UICommand(this, "EditCut")));
            UICommand.Commands.Add((uc = new UICommand(this, "EditPaste")));
            UICommand.Commands.Add((uc = new UICommand(this, "EditDeleteAll")));

            UICommand.Commands.Add((uc = new UICommand(this, "ViewToolbar")));
            uc.UpdateEventHandler += this.OnViewToolbarUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "ViewStatusBar")));
            uc.UpdateEventHandler += this.OnViewStatusBarUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "ViewSearchPanel")));
            uc.UpdateEventHandler += this.OnViewSearchPanelUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "ViewHistoryPanel")));
            uc.UpdateEventHandler += this.OnViewHistoryPanelUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "ViewCommandPanel")));
            uc.UpdateEventHandler += this.OnViewCommandPanelUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "ViewContextPanel")));
            uc.UpdateEventHandler += this.OnViewContextPanelUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "ViewGuidePanel")));
            uc.UpdateEventHandler += this.OnViewGuidePanelUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "ViewDependencyToolbar")));
            uc.UpdateEventHandler += this.OnViewDependencyToolbarUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "ViewAutoAdjustRowWidth")));
            UICommand.Commands.Add((uc = new UICommand(this, "ViewAdjustRowWidthToTheLeft")));
            UICommand.Commands.Add((uc = new UICommand(this, "ViewKwicListView")));
            UICommand.Commands.Add((uc = new UICommand(this, "ViewDependencyTreeView")));
            UICommand.Commands.Add((uc = new UICommand(this, "ViewSplitView")));

            UICommand.Commands.Add((uc = new UICommand(this, "SearchSelectCorpus")));
            uc.UpdateEventHandler += this.OnSearchSelectCorpusUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "SearchSetSearchFilters")));
            uc.UpdateEventHandler += this.OnSearchSetSearchFiltersUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "SearchStringSearchSettings")));
            uc.UpdateEventHandler += this.OnSearchStringSearchSettingsUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "SearchTagSearchSettings")));
            uc.UpdateEventHandler += this.OnSearchTagSearchSettingsUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "SearchDependencySearchSettings")));
            uc.UpdateEventHandler += this.OnSearchDependencySearchSettingsUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "SearchCollocationSettings")));
            uc.UpdateEventHandler += this.OnSearchCollocationSettingsUpdate;
            UICommand.Commands.Add((uc = new UICommand(this, "SearchBeginSearch")));
            uc.UpdateEventHandler += this.OnSearchBeginSearchUpdate;

            UICommand.Commands.Add((uc = new UICommand(this, "FormatShiftPivotLeft")));
            UICommand.Commands.Add((uc = new UICommand(this, "FormatShiftPivotRight")));
            UICommand.Commands.Add((uc = new UICommand(this, "FormatHilightPreviousWord")));
            UICommand.Commands.Add((uc = new UICommand(this, "FormatHilightNextWord")));

            UICommand.Commands.Add((uc = new UICommand(this, "ToolsCreateSQLiteCorpus")));
            UICommand.Commands.Add((uc = new UICommand(this, "ToolsCreateMySQLCorpus")));
            UICommand.Commands.Add((uc = new UICommand(this, "OptionsSettings")));

            UICommand.Commands.Add((uc = new UICommand(this, "HelpAbout")));
            #endregion

            // CommandPanelCallback
            commandPanel.OnBeginSearch = this.BeginSearchHandler;
            commandPanel.OnNarrowSearch = this.BeginSearchNarrowHandler;
            commandPanel.OnBeginWordList = this.BeginWordListHandler;

            // KwicViewCallback
            this.kwicView.OnUpdateGuidePanel += new UpdateGuidePanelDelegate(this.UpdateGuidePanelHandler);
            this.kwicView.OnCurrentChanged += new CurrentChangedDelegate(this.CurrentChangedHandler);
            this.kwicView.OnContextRequested += new RequestContextDelegate(this.RequestContextHandler);

            // HistoryGuidePanelCallback
            this.historyGuidePanel.OnNavigateHistory +=new NavigateHistoryDelegate(this.NavigateHistoryHandler);
            this.historyGuidePanel.OnSaveHistory += new EventHandler(this.SaveHistoryHandler);
            this.historyGuidePanel.OnDeleteHistory += new EventHandler(this.DeleteHistoryHandler);
        }

        public void ChangeStyle(VisualStyle st)
        {
            this.Style = st;
            this.dockingManager.Style = st;
        }

        /// <summary>
        /// Docking Panel̕\E\؂ւ
        /// </summary>
        /// <param name="c"></param>
        private void SwitchVisible(Content c)
        {
            if (c.Visible)
            {
                this.dockingManager.HideContent(c);
            }
            else
            {
                this.dockingManager.ShowContent(c);
            }
        }

        public void IdleUpdate()
        {
            UICommand.UpdateCommands();
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            // CommandPanelɃXbhfw
            this.commandPanel.Abort(false);

            // DockingԂۑ
            dockingManager.SaveConfigToFile(m_DockStateFile);

            // [Uݒۑ
            UserSettings.GetInstance().LastCorpus = m_Model.CurrentSearchConditions.CorpusCond.Corpora;

        }

        delegate void BeginSentenceEditDele(Corpus c, int i, int j);

        public void CurrentChangedHandler(Corpus cps, int senid)
        {
            int cwid = this.kwicView.GetCurrentCenterWordID();
            if (cps != null && senid >= 0) {
                // DependencyEditJn
                this.kwicView.Invoke(new BeginSentenceEditDele(this.kwicView.BeginSentenceEdit), cps, senid, cwid);
                // StatusBarXV
                this.statusStrip1.SetCorpusName(cps.Name);
                this.statusStrip1.SetSentenceNo(senid);
            }
        }

        public void UpdateGuidePanelHandler(Lexeme lex)
        {
            this.guidePanel.SetLexeme( lex );
        }

        /// <summary>
        /// w肳ꂽ̎ނɂView؂ւ
        /// </summary>
        /// <param name="st"></param>
        public IChaKiView ChangeView(SearchType st)
        {
            IChaKiView activeView = null;

            this.kwicView.SetVisible(false);
            this.wordListView.SetVisible(false);

            if (st == SearchType.TagWordList || st == SearchType.DepWordList)
            {
                activeView = this.wordListView;
            }
            else
            {
                activeView = this.kwicView;
            }

            if (activeView != null)
            {
                activeView.SetVisible(true);
            }
            return activeView;
        }
    }
}