using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Corpora
{
    public enum LP
    {
        Surface = 0,
        Reading = 1,
        Pronunciation = 2,
        BaseLexeme = 3,
        PartOfSpeech = 4,
        CType = 5,
        CForm = 6,
    }

    public class Lexeme
    {
        /// <summary>
        /// ꑮ̖́iLexemeNX̃vpeBƈv邱Ɓj
        /// </summary>
        public static readonly Dictionary<LP,string> PropertyName =
            new Dictionary<LP, string> {
                {LP.Surface, "Surface" },
                {LP.Reading, "Reading" },
                {LP.Pronunciation, "Pronunciation" },
                {LP.BaseLexeme, "BaseLexeme" },
                {LP.PartOfSpeech, "PartOfSpeech" },
                {LP.CType, "CType" },
                {LP.CForm, "CForm" }
            };
        private static char[] TabSeparator = new char[] { '\t' };
        private static char[] CommaSeparator = new char[] { ',' };

        public Lexeme() 
        {
            properties = new Dictionary<LP, object>();
        }

        public Lexeme(Lexicon parent, string s)
        {
            properties = new Dictionary<LP, object>();
            this.Surface = s;
            this.Reading = string.Empty;
            this.Pronunciation = string.Empty;
            this.PartOfSpeech = parent.GetPartOfSpeech(string.Empty);
            this.CType = parent.GetCType(string.Empty);
            this.CForm = parent.GetCForm(string.Empty);
            this.BaseLexeme = this;

        }

        public int CharLength
        {
            get { return this.Surface.Length; }
        }

        public static Lexeme FromChasenFormat(Lexicon parent, string s)
        {
            Lexeme lex = new Lexeme();

            string[] tags = s.Split(TabSeparator);
            if (tags.Length < 6)
            {
                throw new ArgumentException();
            }
            lex.Surface = tags[0];
            lex.Reading = tags[1];
            lex.Pronunciation = tags[1];
            lex.PartOfSpeech = parent.GetPartOfSpeech(tags[3]);
            lex.CType = parent.GetCType(tags[4]);
            lex.CForm = parent.GetCForm(tags[5]);
            lex.BaseLexeme = lex; //@todo
            return lex;
        }

        public static Lexeme FromMecabFormat(Lexicon parent, string s)
        {
            Lexeme lex = new Lexeme();

            string[] tags = s.Split(TabSeparator);
            if (tags.Length < 2)
            {
                throw new ArgumentException();
            }
            lex.Surface = tags[0];

            string subtagstr = tags[1].Replace("*", "") + ",,,,";
            string[] subtags = subtagstr.Split(CommaSeparator);
            if (subtags.Length < 9)
            {
                throw new ArgumentException();
            }
            StringBuilder postag = new StringBuilder();
            for (int i = 0; i < 4; i++)
            {
                if (subtags[i].Length == 0)
                {
                    break;
                }
                if (i > 0)
                {
                   postag.Append("-");
                }
                postag.Append(subtags[i]);
            }
            lex.PartOfSpeech = parent.GetPartOfSpeech( postag.ToString() );
            lex.CType = parent.GetCType(subtags[4]);
            lex.CForm = parent.GetCForm(subtags[5]);
            lex.BaseLexeme = lex; //@todo
            lex.Reading = string.Empty;
            lex.Pronunciation = string.Empty;
            lex.Reading = subtags[7];
            lex.Pronunciation = subtags[8];
            return lex;
        }

        private int id;
        private Dictionary<LP, object> properties;
        private int frequency;

        public virtual int ID
        {
            get { return id; }
            set { id = value; }
        }
        public virtual string Surface
        {
            get { return properties[LP.Surface] as string; }
            set { properties[LP.Surface] = value; }
        }
        public virtual string Reading
        {
            get { return properties[LP.Reading] as string; }
            set { properties[LP.Reading] = value; }
        }
        public virtual string Pronunciation
        {
            get { return properties[LP.Pronunciation] as string; }
            set { properties[LP.Pronunciation] = value; }
        }
        public virtual Lexeme BaseLexeme
        {
            get { return properties[LP.BaseLexeme] as Lexeme; }
            set { properties[LP.BaseLexeme] = value; }
        }
        public virtual PartOfSpeech PartOfSpeech
        {
            get { return properties[LP.PartOfSpeech] as PartOfSpeech; }
            set { properties[LP.PartOfSpeech] = value; }
        }
        public virtual CType CType
        {
            get { return properties[LP.CType] as CType; }
            set { properties[LP.CType] = value; }
        }
        public virtual CForm CForm
        {
            get { return properties[LP.CForm] as CForm; }
            set { properties[LP.CForm] = value; }
        }
        public virtual int Frequency
        {
            get { return this.frequency; }
            set { this.frequency = value; }
        }

        public virtual object GetProperty( LP tag )
        {
            return properties[tag];
        }

        public virtual string GetStringProperty(LP tag)
        {
            switch (tag)
            {
                case LP.Surface:
                    return this.Surface;
                case LP.Reading:
                    return this.Reading;
                case LP.BaseLexeme:
                    return this.BaseLexeme.Surface;
                case LP.Pronunciation:
                    return this.Pronunciation;
                case LP.PartOfSpeech:
                    return this.PartOfSpeech.Name;
                case LP.CType:
                    return this.CType.Name;
                case LP.CForm:
                    return this.CForm.Name;
            }
            return null;
        }

        public virtual string GetStringPropertyShort(LP tag)
        {
            switch (tag)
            {
                case LP.Surface:
                    return this.Surface;
                case LP.Reading:
                    return this.Reading;
                case LP.BaseLexeme:
                    return this.BaseLexeme.Surface;
                case LP.Pronunciation:
                    return this.Pronunciation;
                case LP.PartOfSpeech:
                    return this.PartOfSpeech.Name1;   //Zk`
                case LP.CType:
                    return this.CType.Name;
                case LP.CForm:
                    return this.CForm.Name;
            }
            return null;
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("{0},", this.Surface);
            sb.AppendFormat("{0},", this.Reading);
            sb.AppendFormat("{0},", this.Pronunciation);
            sb.AppendFormat("{0},", this.PartOfSpeech.Name);
            sb.AppendFormat("{0},", this.BaseLexeme.Surface);
            sb.AppendFormat("{0},", this.CType.Name);
            sb.AppendFormat("{0}", this.CForm.Name);
            return sb.ToString();
//return this.Surface;
        }
    }
}
