using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Corpora
{
    public class Lexicon
    {
        private SortedList<string, Lexeme> m_entries;

        public Lexicon()
        {
            m_entries = new SortedList<string, Lexeme>();

            PartsOfSpeech = new Dictionary<string, PartOfSpeech>();
            CTypes = new Dictionary<string, CType>();
            CForms = new Dictionary<string, CForm>();
        }

        public SortedList<string, Lexeme> Entries
        {
            get { return m_entries; }
            set { m_entries = value; }
        }

        public void Reset()
        {
            m_entries.Clear();
            this.PartsOfSpeech.Clear();
            this.CTypes.Clear();
            this.CForms.Clear();
        }

        /// <summary>
        /// ɌǉB
        /// ꂪɂ΂̃GgԂB
        /// </summary>
        /// <param name="s">̕\w`</param>
        /// <returns></returns>
        public Lexeme AddEntry(string s)
        {
            if (m_entries.ContainsKey(s))
            {
                return m_entries[s];
            }
            Lexeme m = new Lexeme(this,s);
            m_entries.Add(s, m);
            return m;
        }

        /// <summary>
        /// ɌǉB
        /// ꂪɂ΂̃GgԂB
        /// </summary>
        /// <param name="s">ChaSen/CaboChatH[}bgŕ\ꂽP̃f[^B</param>
        /// <returns></returns>
        public Lexeme AddEntryChasen(string s)
        {
            if (m_entries.ContainsKey(s))
            {
                return m_entries[s];
            }
            Lexeme m = Lexeme.FromChasenFormat(this,s);
            m_entries.Add(s, m);
            return m;
        }

        public Lexeme AddEntryMecab(string s)
        {
            if (m_entries.ContainsKey(s))
            {
                return m_entries[s];
            }
            Lexeme m = Lexeme.FromMecabFormat(this, s);
            m_entries.Add(s, m);
            return m;
        }

        /// <summary>
        /// `LexemeTBȂΓo^(?)
        /// </summary>
        /// <param name="surface"></param>
        /// <param name="pos"></param>
        /// <param name="ct"></param>
        /// <param name="cf"></param>
        /// <returns></returns>
        public Lexeme GetBaseLexeme(string s)
        {
            throw new NotImplementedException();
        }

        // PartOfSpeech̊Ǘ
        public Dictionary<string, PartOfSpeech> PartsOfSpeech { get; set; }
        public PartOfSpeech GetPartOfSpeech(string name)
        {
            PartOfSpeech obj = null;
            if (!PartsOfSpeech.TryGetValue(name, out obj))
            {
                obj = new PartOfSpeech(name);
                PartsOfSpeech.Add(name, obj);
            }
            return obj;
        }

        // CType̊Ǘ
        public Dictionary<string, CType> CTypes { get; set; }
        public CType GetCType(string name)
        {
            CType obj = null;
            if (!CTypes.TryGetValue(name, out obj))
            {
                obj = new CType(name);
                CTypes.Add(name, obj);
            }
            return obj;
        }

        // CForm̊Ǘ
        public Dictionary<string, CForm> CForms { get; set; }
        public CForm GetCForm(string name)
        {
            CForm obj = null;
            if (!CForms.TryGetValue(name, out obj))
            {
                obj = new CForm(name);
                CForms.Add(name, obj);
            }
            return obj;
        }
    


    }
}
