using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;

namespace ChaKi.Entity.Kwic
{
    public class KwicPortion
    {
        public KwicPortion()
        {
            this.Words = new List<KwicWord>();
        }

        public List<KwicWord> Words { get; set; }

        public void AddLexeme(Lexeme lex, int attr)
        {
            this.Words.Add(new KwicWord(lex, attr));
        }

        public void AddText(string text, int attr)
        {
            this.Words.Add(new KwicWord(text, attr));
        }

        public static int Compare(KwicPortion x, KwicPortion y, bool isLeftPortion)
        {
            int n1 = x.Words.Count;
            int n2 = y.Words.Count;
            int n = Math.Min(n1, n2);

            if (!isLeftPortion)
            {
                for (int i = 0; i < n; i++)
                {
                    string s1 = null;
                    string s2 = null;
                    Lexeme w1 = x.Words[i].Lex;
                    if (w1 != null)
                    {
                        s1 = w1.GetStringProperty(LP.Surface);
                    }
                    else
                    {
                        s1 = x.Words[i].Text;
                    }
                    Lexeme w2 = y.Words[i].Lex;
                    if (w2 != null)
                    {
                        s2 = w2.GetStringProperty(LP.Surface);
                    }
                    else
                    {
                        s2 = y.Words[i].Text;
                    }
                    if (s1 == null || s2 == null)
                    {
                        throw new ArgumentNullException("Cannot compare KWIC Portions");
                    }
                    int c = string.Compare(s1, s2);
                    if (c != 0)
                    {
                        return c;
                    }
                }
                // n܂ł͂܂
                return (n1 - n2);   // n1̕+, n2̕-
            }
            else
            {
                // 납rȊO͂܂
                for (int i = 0; i < n; i++)
                {
                    string s1 = null;
                    string s2 = null;
                    Lexeme w1 = x.Words[n1 - i - 1].Lex;
                    if (w1 != null)
                    {
                        s1 = w1.GetStringProperty(LP.Surface);
                    }
                    else
                    {
                        s1 = x.Words[n1 - i - 1].Text;
                    }
                    Lexeme w2 = y.Words[n2 - i - 1].Lex;
                    if (w2 != null)
                    {
                        s2 = w2.GetStringProperty(LP.Surface);
                    }
                    else
                    {
                        s2 = y.Words[n2 - i - 1].Text;
                    }
                    if (s1 == null || s2 == null)
                    {
                        throw new ArgumentNullException("Cannot compare KWIC Portions");
                    }
                    int c = string.Compare(s1, s2);
                    if (c != 0)
                    {
                        return c;
                    }
                }
                return (n1 - n2);   // n1̕+, n2̕-
            }
            return 0;
        }

        public int Count
        {
            get { return this.Words.Count; }
        }

        public void PushFront( KwicWord w)
        {
            this.Words.Insert(0, w);
        }

        public void PushBack(KwicWord w)
        {
            this.Words.Add(w);
        }

        public KwicWord PopFront()
        {
            if (this.Words.Count > 0)
            {
                KwicWord w = this.Words[0];
                this.Words.RemoveAt(0);
                return w;
            }
            return null;
        }

        public KwicWord PopBack()
        {
            if (this.Words.Count > 0)
            {
                KwicWord w = this.Words[this.Words.Count - 1];
                this.Words.RemoveAt(this.Words.Count - 1);
                return w;
            }
            return null;
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            foreach (KwicWord w in this.Words)
            {
                if (sb.Length > 0)
                {
                    sb.Append(";");
                }
                if (w.Lex != null)
                {
                    sb.Append(w.Lex.ID);
                }
                else
                {
                    sb.Append("\"");
                    sb.Append(w.Text);
                    sb.Append("\"");
                }
            }
            return sb.ToString();
        }
    }
}
