﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using System.Xml.Serialization;

namespace ChaKi.Entity.Kwic
{
    public class KwicWord
    {
        public const int KWA_NONE		= 0x00000000;
        public const int KWA_COMPWORD   = 0x00000001;	// 複合語・複合語の構成語
        public const int KWA_PIVOT      = 0x00000010;
        public const int KWA_HILIGHT    = 0x00000020;
        public const int KWA_SECOND     = 0x00000040;	// 絞込みマッチワード


        public KwicWord()
        {
            this.ExtAttr = 0;
        }
        public KwicWord(Lexeme lex, int attr)
        {
            this.Lex = lex;
            this.Text = null;
            this.ExtAttr = attr;
        }
        public KwicWord(string text, int attr)
        {
            this.Text = text;
            this.Lex = null;
            this.ExtAttr = attr;
        }
        [XmlIgnore]
        public Lexeme Lex { get; set; }
        public string Text { get; set; }
        public int ExtAttr { get; set; }
    }
}
