using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Search
{
    public class SearchConditions : ICloneable
    {
        /// <summary>
        /// ConditionsSequence̒OConditionsƂ錟̏WZq(None,And,Or)
        /// ʂ̉ZɂẮASearchConditionsSequenceNXQ
        /// </summary>
        public SearchSequenceOperator Operator { get; set; }
        public SearchType ActiveSearch { get; set; }
        public CorpusCondition CorpusCond { get; set; }
        public FilterCondition FilterCond { get; set; }
        public StringSearchCondition StringCond { get; set; }
        public TagSearchCondition TagCond { get; set; }
        public DepSearchCondition DepCond { get; set; }

        public SearchConditions()
        {
            Operator = SearchSequenceOperator.None;
            ActiveSearch = SearchType.Undefined;
            CorpusCond = new CorpusCondition();
            FilterCond = new FilterCondition();
            StringCond = new StringSearchCondition();
            TagCond = new TagSearchCondition();
            DepCond = new DepSearchCondition();
        }

        public SearchConditions(SearchConditions src)
        {
            Operator = src.Operator;
            ActiveSearch = src.ActiveSearch;
            CorpusCond = new CorpusCondition(src.CorpusCond);
            FilterCond = new FilterCondition(src.FilterCond);
            StringCond = new StringSearchCondition(src.StringCond);
            TagCond = new TagSearchCondition(src.TagCond);
            DepCond = new DepSearchCondition(src.DepCond);
        }

        public void Reset()
        {
            Operator = SearchSequenceOperator.None;
            ActiveSearch = SearchType.Undefined;
            CorpusCond.Reset();
            FilterCond.Reset();
            StringCond.Reset();
            TagCond.Reset();
            DepCond.Reset();
        }

        public object Clone()
        {
            SearchConditions obj = new SearchConditions(this);
            return obj;
        }
    }
}
