﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data.SQLite;
using System.Data.Common;
using System.IO;

namespace ChaKi.Service.Database
{
    public class SQLiteDBService : DBService
    {
        public SQLiteDBService()
        {
        }

        public override void GetDatabaseList(ref List<string> dblist)
        {
            // dummy
            return;
        }

        public override void CreateDatabase()
        {
            // dummy
        }

        public override void DropDatabase()
        {
            File.Delete(DBParam.Name);
        }


        public override void SetupConnection(NHibernate.Cfg.Configuration cfg)
        {
            cfg.SetProperty("dialect", "NHibernate.Dialect.SQLiteDialect");
            cfg.SetProperty("connection.provider", "NHibernate.Connection.DriverConnectionProvider");
            cfg.SetProperty("connection.driver_class", "NHibernate.Driver.SQLite20Driver");
            cfg.SetProperty("query.substitutions", "true=1;false=0");
            cfg.SetProperty("connection.connection_string", GetConnectionString());
            //cfg.SetProperty("show_sql", "true");
        }

        public override string GetConnectionString()
        {
            return string.Format("Data Source=\"{0}\";Version=3", DBParam.DBPath);
        }

        public override DbConnection GetDbConnnection()
        {
            return new SQLiteConnection(GetConnectionString());
        }

        public override string GetDefault()
        {
            return "\"\"";
        }
    }
}
