﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using System.IO;

namespace ChaKi.Service.Readers
{
    public class PlainTextReader : CorpusSourceReader
    {
        private Corpus m_Corpus;
        private Lexicon m_Lexicon;

        public PlainTextReader(Corpus corpus)
        {
            m_Corpus = corpus;
            m_Lexicon = corpus.Lex;
        }

        public void ReadFromFile(string path, string encoding)
        {
            using (TextReader streamReader = new StreamReader(path, Encoding.GetEncoding(encoding)))
            {
                int n = 0;
                int charPos = 0;
                string s;

                while ((s = streamReader.ReadLine()) != null)
                {
                    Sentence sen = new Sentence();
                    sen.Text = s;
                    sen.StartChar = charPos;
                    m_Corpus.AddSentence(sen);
                    charPos += s.Length;
                    sen.EndChar = charPos;

                    Lexeme m = m_Lexicon.AddEntry(s);
                    if (m != null)
                    {
                        Word w = sen.AddWord(m);
                        //@todo: 英語の場合：平文を再現するにはデリミタで単語を区切る必要がある

                        w.StartChar = sen.StartChar;
                        w.EndChar = sen.EndChar;
                    }

                    // 文全体に対して文節を追加
                    Segment seg = new Segment();
                    seg.StartChar = sen.StartChar;
                    seg.EndChar = sen.EndChar;
                    seg.Text = "Bunsetsu";
                    m_Corpus.AddSegment(seg);
                    Segment dummy = new Segment();
                    dummy.StartChar = sen.EndChar;
                    dummy.EndChar = sen.EndChar;
                    dummy.Text = "Bunsetsu";
                    m_Corpus.AddSegment(dummy);
                    Link link = new Link();
                    link.From = seg;
                    link.To = dummy;
                    link.Text = "D";
                    m_Corpus.AddLink(link);

                    Console.Write("> {0}\r", ++n);
                }
            }
        }
    }
}
