using System.Collections;
using System.Collections.Generic;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Search;
using NHibernate;
using NHibernate.Criterion;
using ChaKi.Entity.Kwic;
using System;
using System.Text;
using System.Diagnostics;

namespace ChaKi.Service.Search
{
    public class TagSearchService : SearchServiceBase
    {
        private KwicList m_Model;
        private LexemeResultSet m_LexemeResultSet;  //ԌʂƂĂLexemeXg̃Xg

        public TagSearchService(KwicList model, SearchConditionsSequence condSeq, CommandProgress progress)
            : base(condSeq, progress)
        {
            m_Model = model;
            m_LexemeResultSet = null;
        }

        /// <summary>
        /// R[pXƂTagSearch{
        /// </summary>
        /// <param name="c"></param>
        protected override void ExecuteSearchSession(Corpus c)
        {
            SearchConditions cond = m_CondSeq.Last;  //@todo: i荞ݓłCondSeqȂ΂ȂȂ

            // Lexemě(HQL)쐬Aʂ𓾂
            m_LexemeResultSet = QueryLexemeResultSet(cond.TagCond.LexemeConds);
            if (m_LexemeResultSet == null || m_LexemeResultSet.Count == 0)
            {
                m_Progress.SetRange(0);     // qbgȂ
                return;
            }

            // Worď(HQL)쐬AsB
            string qstr = QueryBuilder.BuildTagSearchQuery(m_LexemeResultSet, cond);
            IQuery query = m_Session.CreateQuery(qstr);
            IList queryResult = query.List();
            int totalCount = queryResult.Count;

            // ܂łŌ͏IB

            // ꂽWordɑ΂āAWordĂSentenceǂA
            // eKwicɕϊEo͂
            int n = 0;
            m_Progress.SetRange(totalCount);
            foreach (Word word in queryResult)
            {
                int position = word.Pos;   // KWICcenter wordƂȂ̈ʒu
                Sentence sen = word.Sen;
                KwicItem ki = new KwicItem(c, sen.ID, word.ID);
                int pos = 0;
                foreach (Word w in sen.Words)
                {
                    Lexeme lex = w.Lex;
                    if (pos < position)
                    {
                        ki.Left.AddLexeme(lex, 0);
                    }
                    else if (pos == position)
                    {
                        ki.Center.AddLexeme(lex, KwicWord.KWA_PIVOT);
                    }
                    else
                    {
                        ki.Right.AddLexeme(lex, 0);
                    }
                    pos++;
                }
                m_Model.AddKwicItem(ki);
                m_Progress.Increment();
                n++;
            }
        }
    }
}
