﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ChaKi.Common;
using ChaKi.Common.Settings;

namespace ChaKi.Options
{
    public partial class CustomizePropertyBoxDialog : Form
    {
        public CustomizePropertyBoxDialog()
        {
            InitializeComponent();

            this.dataGridView1.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            this.dataGridView1.MultiSelect = false;
            this.dataGridView1.Columns[0].DataPropertyName = "TagName";
            this.dataGridView1.Columns[1].DataPropertyName = "DisplayName";
            this.dataGridView1.Columns[2].DataPropertyName = "IsVisible";
        }

        public IList<PropertyBoxItemSetting> Model
        {
            set
            {
                this.bindingSource1.DataSource = value;
            }
            get
            {
                return this.bindingSource1.DataSource as IList<PropertyBoxItemSetting>;
            }
        }

        /// <summary>
        /// Move Up Current Row
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button3_Click(object sender, EventArgs e)
        {
            DataGridViewSelectedRowCollection rows = this.dataGridView1.SelectedRows;
            if (rows.Count != 1 || rows[0].Index == 0)
            {
                return;
            }
            int row = rows[0].Index;
            PropertyBoxItemSetting item = Model[row];
            Model.RemoveAt(row);
            Model.Insert(row-1, item);
            this.dataGridView1.Rows[row-1].Selected = true;
        }

        /// <summary>
        /// Move Down current Row
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button4_Click(object sender, EventArgs e)
        {
            DataGridViewSelectedRowCollection rows = this.dataGridView1.SelectedRows;
            if (rows.Count != 1 || rows[0].Index == this.Model.Count-1)
            {
                return;
            }
            int row = rows[0].Index;
            PropertyBoxItemSetting item = Model[row];
            Model.RemoveAt(row);
            Model.Insert(row + 1, item);
            this.dataGridView1.Rows[row + 1].Selected = true;
        }

        /// <summary>
        /// Reset to Default
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button5_Click(object sender, EventArgs e)
        {
            PropertyBoxSettings.Default(this.Model);
            this.dataGridView1.Refresh();
        }
    }
}
