﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Search;

namespace ChaKi.Panels.ConditionsPanes
{
    public partial class FilterControl : UserControl
    {
        public FilterControl()
        {
            InitializeComponent();
        }

        public void UpdateView(FilterCondition model)
        {
            this.comboBox1.Text = model.DocumentFilter;
            this.radioButton1.Checked = (model.ResultsetFilter.FetchType == FetchType.Incremental);
            this.radioButton2.Checked = (model.ResultsetFilter.FetchType == FetchType.Decremental);
            this.radioButton3.Checked = (model.ResultsetFilter.FetchType == FetchType.Random);
            int val = model.ResultsetFilter.Max;
            this.textBox2.Text = (val >= 0) ? val.ToString() : string.Empty;
            val = model.ResultsetFilter.StartAt;
            this.textBox3.Text = (val >= 0) ? val.ToString() : string.Empty;
            this.checkBox1.Checked = model.ResultsetFilter.IsAutoIncrement;
        }

        public void Synchronize(FilterCondition model)
        {
            model.DocumentFilter = this.comboBox1.Text;

            FetchType ftype = FetchType.Incremental;
            if (this.radioButton2.Checked) ftype = FetchType.Decremental;
            if (this.radioButton3.Checked) ftype = FetchType.Random;
            int max = -1;
            string s = this.textBox2.Text.Trim();
            if (s.Length > 0) Int32.TryParse(s, out max);
            int from = 0;
            s = this.textBox3.Text.Trim();
            if (s.Length > 0) Int32.TryParse(s, out from);
            bool isAutoIncrement = this.checkBox1.Checked;

            model.ResultsetFilter = new ResultsetFilter()
            {
                FetchType = ftype,
                StartAt = from,
                Max = max,
                IsAutoIncrement = isAutoIncrement
            };
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            UpdateEnableState();
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            UpdateEnableState();
        }

        private void radioButton3_CheckedChanged(object sender, EventArgs e)
        {
            UpdateEnableState();
        }

        private void UpdateEnableState()
        {
            checkBox1.Enabled = (radioButton1.Checked);
            label2.Enabled = !(radioButton3.Checked);
            textBox3.Enabled = !(radioButton3.Checked);
        }
    }
}
