using System;
using System.Windows.Forms;

namespace ChaKi.Common.Widgets
{
    public partial class PropertyInputDialog : Form
    {
        public PropertyInputDialog()
        {
            InitializeComponent();
        }

        public event PropertyInputDone OnInputDone;
        public event PropertyInputCancel OnInputCancel;

        public int Index { get; set; }

        public string EditText
        {
            get { return this.textBox1.Text; }
            set { this.textBox1.Text = value; }
        }

        public bool IsRegEx
        {
            get { return this.checkBox1.Checked; }
            set { this.checkBox1.Checked = value; }
        }

        public bool IsCaseSensitive
        {
            get { return this.checkBox2.Checked; }
            set { this.checkBox2.Checked = value; }
        }

        public void Done()
        {
            OnInputDone(this, new InputDoneEventArgs(this.Index, this.EditText, false, false));
        }

        private void PropertyInputDialog_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible)
            {
                this.textBox1.Focus();
            }
        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                Done();
            }
            else if (e.KeyChar == '\x1b')
            {
                OnInputCancel(this, e);
            }
        }
    }
}