﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Settings
{
    public enum ExportType
    {
        Excel = 0,
        CSV = 1,
    }

    public enum ExportFormat
    {
        Sentence = 0,
        Portion = 1,
        Word = 2,
    }

    public class ExportSetting
    {
        public ExportSetting()
        {
            this.ExportType = ExportType.Excel;
            this.ExportFormat = ExportFormat.Sentence;
            this.MixPOS = false;
            this.UseSpacing = false;
        }

        public ExportSetting(ExportSetting src)
        {
            CopyFrom(src);
        }

        public void CopyFrom(ExportSetting src)
        {
            if (src == null) return;
            this.ExportType = src.ExportType;
            this.ExportFormat = src.ExportFormat;
            this.MixPOS = src.MixPOS;
            this.UseSpacing = src.UseSpacing;
        }

        public ExportType ExportType { get; set; }
        public ExportFormat ExportFormat { get; set; }
        public bool MixPOS { get; set; }
        public bool UseSpacing { get; set; }
    }
}
