﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using System.IO;
using ChaKi.Entity.Kwic;
using NHibernate;
using System.Xml.Serialization;
using System.Xml;

namespace ChaKi.Service.Export
{
    public class ExportServiceXml : ExportServiceBase
    {
        public ExportServiceXml(XmlWriter wr)
        {
            m_XmlWriter = wr;
        }

        public override void ExportItem(KwicItem ki)
        {
            if (m_XmlWriter == null) throw new InvalidOperationException("XmlWriter is null.");

            IQuery q = m_Session.CreateQuery(string.Format("from Sentence where ID={0}", ki.SenID));
            Sentence sen = q.UniqueResult<Sentence>();
            if (sen == null)
            {
                throw new Exception(string.Format("Sentence not found. Corpus={0}, senID={1}", ki.Crps.Name, ki.SenID));
            }
            XmlSerializer ser = new XmlSerializer(typeof(Sentence));
            ser.Serialize(m_XmlWriter, sen);
        }
    }
}
