﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Corpora.Annotations;
using System.Data;

namespace ChaKi.TagSetDefinitionEditor
{
    internal class ViewModel
    {
        internal enum Triggers
        {
            Initialize,
            BeginEdit,
            EndEdit,
        }

        internal enum States
        {
            Browsing,
            Editing,
        }

        internal ViewModel()
        {
            this.VersionList = new List<string>();
            this.State = States.Browsing;
        }

        public States State { get; set; }
        public Corpus Corpus { get; set; }
        public TagSet TagSet { get; set; }
        public IList<string> VersionList { get; set; }
        public TagSetVersion CurrentVersion { get; set; }

        public DataTable Segments { get; set; }
        public DataTable Links { get; set; }
        public DataTable Groups { get; set; }

        public int IndexOfCurrentVersion
        {
            get
            {
                return (this.CurrentVersion != null) ? this.VersionList.IndexOf(this.CurrentVersion.Version) : -1;
            }
        }
    }
}
