﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;
using ChaKi.Service.Annotation;

namespace ChaKi.Common
{
    public partial class DocumentFilterListDialog : Form
    {
        public string SelectedValue;

        public DocumentFilterListDialog()
        {
            this.SelectedValue = string.Empty;
            InitializeComponent();
        }

        public void LoadTags()
        {
            this.listBox1.Items.Clear();
            try
            {
                DocumentTagService svc = new DocumentTagService(ChaKiModel.CurrentCorpus);
                svc.Load();
            }
            catch (Exception ex)
            {
                ErrorReportDialog dlg = new ErrorReportDialog("Cannot load DocumentTags", ex);
                dlg.ShowDialog();
                return;
            }
            List<DocumentTag> tags = ChaKiModel.CurrentCorpus.DocumentTags;
            foreach (DocumentTag tag in tags)
            {
                if (tag.Tag.Equals("Bib_ID"))
                {
                    this.listBox1.Items.Add(tag.Description);
                }
            }
        }

        private void listBox1_SelectedValueChanged(object sender, EventArgs e)
        {
            this.SelectedValue = (string)(this.listBox1.SelectedItem);
            this.DialogResult = DialogResult.OK;
        }
    }
}
