﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using Crownwood.DotNetMagic.Docking;
using ChaKi.Options;
using ChaKi.Entity.Search;
using ChaKi.Service.Search;
using ChaKi.Common;
using ChaKi.Entity.Settings;

namespace ChaKi
{
    partial class MainForm
    {
        private void OnFileNew(object sender, EventArgs e)
        {
        }

        private void OnFileOpen(object sender, EventArgs e)
        {
        }

        private void OnFileSave(object sender, EventArgs e)
        {
            OnFileSaveAs(sender, e);
        }

        private void OnFileSaveAs(object sender, EventArgs e)
        {
            FileDialog dlg = new SaveFileDialog();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                this.Save(dlg.FileName, null);
            }
        }

        private void OnFilePrint(object sender, EventArgs e)
        {
        }

        private void OnFileExit(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnEditCopy(object sender, EventArgs e)
        {
        }

        private void OnEditCut(object sender, EventArgs e)
        {
        }

        private void OnEditPaste(object sender, EventArgs e)
        {
        
        }

        private void OnEditDeleteAll(object sender, EventArgs e)
        {
            this.kwicView.DeleteAll();
        }
        
        private void OnViewToolbar(object sender, EventArgs e)
        {
            this.toolStrip.Visible = !this.toolStrip.Visible;
        }

        private void OnViewToolbarUpdate(object sender, EventArgs e)
        {
            this.UICViewToolbarToolStripMenuItem.Checked = this.toolStrip.Visible;
        }

        private void OnViewStatusBar(object sender, EventArgs e)
        {
            this.statusStrip1.Visible = !this.statusStrip1.Visible;
        }

        private void OnViewStatusBarUpdate(object sender, EventArgs e)
        {
            this.UICViewStatusBarToolStripMenuItem.Checked = this.statusStrip1.Visible;
        }

        private void OnViewSearchPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.condPanelContainer);
        }

        private void OnViewSearchPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewSearchPanelToolStripMenuItem.Checked = this.condPanelContainer.Visible;
        }

        private void OnViewHistoryPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.historyGuidePanelContainer);
        }

        private void OnViewHistoryPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewHistoryPanelToolStripMenuItem.Checked = this.historyGuidePanelContainer.Visible;
        }

        private void OnViewCommandPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.commandPanelContainer);
        }

        private void OnViewCommandPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewCommandPanelToolStripMenuItem.Checked = this.commandPanelContainer.Visible;
        }

        private void OnViewContextPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.contextPanelContainer);
        }

        private void OnViewContextPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewContextPanelToolStripMenuItem.Checked = this.contextPanelContainer.Visible;
        }

        private void OnViewGuidePanel(object sender, EventArgs e)
        {
            SwitchVisible(this.guidePanelContainer);
        }

        private void OnViewGuidePanelUpdate(object sender, EventArgs e)
        {
            this.UICViewGuidePanelToolStripMenuItem.Checked = this.guidePanelContainer.Visible;
        }

        private void OnViewDependencyEditPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.dependencyEditContainer);
        }

        private void OnViewDependencyEditPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewDependencyEditPanelToolStripMenuItem.Checked = this.dependencyEditContainer.Visible;
        }

        private void OnViewSentenceTagPanel(object sender, EventArgs e)
        {
            SwitchVisible(this.sentenceTagListPanelContainer);
        }

        private void OnViewSentenceTagPanelUpdate(object sender, EventArgs e)
        {
            this.UICViewSentenceTagPanelToolStripMenuItem.Checked = this.sentenceTagListPanelContainer.Visible;
        }

        

        private void OnViewViewAttributes(object sender, EventArgs e)
        {
            this.kwicView.TwoLineMode = !this.kwicView.TwoLineMode;
        }

        private void OnViewViewAttributesUpdate(object sender, EventArgs e)
        {
            this.UICViewViewAttributesToolStripMenuItem.Checked = this.kwicView.TwoLineMode;
            this.UICViewViewAttributesToolStripButton.Checked = this.kwicView.TwoLineMode;
        }
        
        private void OnViewKwicMode(object sender, EventArgs e)
        {
            this.kwicView.KwicMode = true;
            this.kwicView.RecalcLayout();
        }

        private void OnViewKwicModeUpdate(object sender, EventArgs e)
        {
            this.UICViewKwicModeToolStripMenuItem.Checked = this.kwicView.KwicMode;
            this.UICViewKwicModeToolStripButton.Checked = this.kwicView.KwicMode;
        }

        private void OnViewTextMode(object sender, EventArgs e)
        {
            this.kwicView.KwicMode = false;
            this.kwicView.RecalcLayout();
        }

        private void OnViewTextModeUpdate(object sender, EventArgs e)
        {
            this.UICViewTextModeToolStripMenuItem.Checked = !this.kwicView.KwicMode;
            this.UICViewTextModeToolStripButton.Checked = !this.kwicView.KwicMode;
        }

        private void OnViewLoadAnnotations(object sender, EventArgs e)
        {
            LoadAnnotations();
        }

        private void OnViewAutoAdjustRowWidth(object sender, EventArgs e)
        {
            this.kwicView.AutoAdjustColumnWidths();
        }

        private void OnViewAdjustRowWidthToTheLeft(object sender, EventArgs e)
        {
            this.kwicView.LeftAdjustColumnWidths();
        }

        private void OnSearchSelectCorpus(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 0;
        }

        private void OnSearchSelectCorpusUpdate(object sender, EventArgs e)
        {
            this.UICSearchSelectCorpusToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 0);
        }

        private void OnSearchSetSearchFilters(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 1;
        }

        private void OnSearchSetSearchFiltersUpdate(object sender, EventArgs e)
        {
            this.UICSearchSetSearchFiltersToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 1);
        }

        private void OnSearchStringSearchSettings(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 2;
        }

        private void OnSearchStringSearchSettingsUpdate(object sender, EventArgs e)
        {
            this.UICSearchStringSearchSettingsToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 2);
        }

        private void OnSearchTagSearchSettings(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 3;
        }

        private void OnSearchTagSearchSettingsUpdate(object sender, EventArgs e)
        {
            this.UICSearchTagSearchSettingsToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 3);
        }

        private void OnSearchDependencySearchSettings(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 4;
        }

        private void OnSearchDependencySearchSettingsUpdate(object sender, EventArgs e)
        {
            this.UICSearchDependencySearchSettingsToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 4);
        }

        private void OnSearchCollocationSettings(object sender, EventArgs e)
        {
            this.condPanel.SelectedTabIndex = 5;
        }

        private void OnSearchCollocationSettingsUpdate(object sender, EventArgs e)
        {
            this.UICSearchCollocationSettingsToolStripMenuItem.Checked = (this.condPanel.SelectedTabIndex == 5);
        }

        private void OnSearchBeginSearch(object sender, EventArgs e)
        {
            OnBeginSearch();
        }

        private void OnSearchBeginSearchUpdate(object sender, EventArgs e)
        {
            this.UICSearchBeginSearchToolStripMenuItem.Enabled = this.commandPanel.CanBeginSearch;
        }

        private void OnFormatShiftUpdate(object sender, EventArgs e)
        {
            SearchHistory hist = this.historyGuidePanel.Current;
            bool f = (hist != null && hist.CanShift());
            this.UICFormatShiftPivotLeftToolStripMenuItem.Enabled = f;
            this.UICFormatShiftPivotLeftToolStripButton.Enabled = f;
            this.UICFormatShiftPivotRightToolStripMenuItem.Enabled = f;
            this.UICFormatShiftPivotRightToolStripButton.Enabled = f;
            this.UICFormatHilightNextWordToolStripMenuItem.Enabled = f;
            this.UICFormatHilightNextWordToolStripButton.Enabled = f;
            this.UICFormatHilightPreviousWordToolStripMenuItem.Enabled = f;
            this.UICFormatHilightPreviousWordToolStripButton.Enabled = f;
        }


        private void OnSearchExamineLastSearch(object sender, EventArgs e)
        {
            ErrorReportDialog dlg = new ErrorReportDialog();
            dlg.Text = "Last Query";
            dlg.Message = "Last HQL Query String is:";
            dlg.Detail = QueryBuilder.Instance.LastQuery;
            dlg.ShowDialog();
        }

        private void OnFormatShiftPivotLeft(object sender, EventArgs e)
        {
            SearchHistory hist = this.historyGuidePanel.Current;
            if (hist == null) return;
            hist.Shift(-1);
            this.kwicView.ShiftPivot(-1);

            // TagCondもシフトする
            // History中の条件とCurrentSearchCondtiionsとはインスタンスが異なるので注意
            SearchConditions cond = this.m_Model.CurrentSearchConditions;
            if (cond != null && cond.TagCond != null)
            {
                cond.TagCond.Shift(-1);
            }
        }

        private void OnFormatShiftPivotRight(object sender, EventArgs e)
        {
            SearchHistory hist = this.historyGuidePanel.Current;
            if (hist == null) return;
            hist.Shift(1);
            this.kwicView.ShiftPivot(1);

            // TagCondもシフトする
            // History中の条件とCurrentSearchCondtiionsとはインスタンスが異なるので注意
            SearchConditions cond = this.m_Model.CurrentSearchConditions;
            if (cond != null && cond.TagCond != null)
            {
                cond.TagCond.Shift(1);
            }
        }

        private void OnFormatHilightPreviousWord(object sender, EventArgs e)
        {
            SearchHistory hist = this.historyGuidePanel.Current;
            if (hist == null) return;
            hist.ShiftHilight(-1);
        }

        private void OnFormatHilightNextWord(object sender, EventArgs e)
        {
            SearchHistory hist = this.historyGuidePanel.Current;
            if (hist == null) return;
            hist.ShiftHilight(1);
        }

        private void OnToolsCreateSQLiteCorpus(object sender, EventArgs e)
        {
            CreateSQLiteCorpus dlg = new CreateSQLiteCorpus();
            dlg.ShowDialog();
            dlg.Dispose();
        }

        private void OnToolsCreateMySQLCorpus(object sender, EventArgs e)
        {
            DBLogin dlg = new DBLogin();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                CreateMySQLCorpus dlg2 = new CreateMySQLCorpus();
                dlg2.DBMS = dlg.DBMS;
                dlg2.Server = dlg.Server;
                dlg2.User = dlg.User;
                dlg2.Password = dlg.Password;
                dlg2.DatabaseCandidates = dlg.Databases;
                dlg2.ShowDialog();
                dlg2.Dispose();
            }
        }

        private void OnOptionsSettings(object sender, EventArgs e)
        {
            OptionDialog dlg = new OptionDialog();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                //@ todo
            }
        }

        private void OnOptionsWordAttributeColors(object sender, EventArgs e)
        {
            WordAttributeColorSettingDialog dlg = new WordAttributeColorSettingDialog();
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                //@ todo
            }
        }

        private void OnHelpAbout(object sender, EventArgs e)
        {
            AboutChaKiDialog dlg = new AboutChaKiDialog();
            dlg.ShowDialog();
            dlg.Dispose();
        }

        
    }
}
