﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Corpora.Annotations
{
    public abstract class Annotation
    {
        /// <summary>
        /// このアノテーションの主値であるTag定義
        /// </summary>
        public virtual Tag Tag { get; set; }

        /// <summary>
        /// このアノテーションがどのVersionのTagSetによって付加されたか
        /// </summary>
        public virtual TagSetVersion Version { get; set; }

        /// <summary>
        /// このアノテーション付加作業を行ったProjectへの参照
        /// </summary>
        public virtual Project Proj { get; set; }

        /// <summary>
        /// 個別のアノテーションに対するコメント
        /// </summary>
        public virtual string Comment { get; set; }
    }
}
