﻿using System;
using ChaKi.Entity.Corpora;
using NHibernate;


namespace ChaKi.Service.DependencyEdit
{
    internal class DepOperation
    {
        public DepOperation()
        {
        }

        public DepOperation(DOType t, object[] paramlist)
        {
            m_OpType = t;
            m_ParamList = paramlist;
        }

        protected DOType m_OpType;
        protected object[] m_ParamList;

        public virtual void Execute(Sentence sen, ISession session)
        {
            switch (m_OpType)
            {
                case DOType.MoveArrow:
                    {
                        int ibmax = sen.Bunsetsus.Count;
                        int ib = (int)m_ParamList[0];
                        int id_org = (int)m_ParamList[1];
                        int id_new = (int)m_ParamList[2];
                        if (ib < 0 || ib >= ibmax || id_org < 0 || id_org >= ibmax || id_new < 0 || id_new >= ibmax)
                        {
                            throw new IndexOutOfRangeException("Invalid dependency index");
                        }
                        Bunsetsu b = (Bunsetsu)sen.Bunsetsus[ib];
                        b.DependsTo = (Bunsetsu)sen.Bunsetsus[id_new];
                    }
                    break;
                case DOType.Split:
                    {
                        int b_at = (int)m_ParamList[0];
                        int w_at = (int)m_ParamList[1];
                        Bunsetsu newBunsetsu = (Bunsetsu)sen.SplitBunsetsu(b_at, w_at);
                        if (newBunsetsu != null)
                        {
                            // 生成された文節をDBへ追加、Persistentオブジェクトにする。
                            session.Save(newBunsetsu);
                        }
                    }
                    break;
                case DOType.Merge:
                    {
                        int b_at = (int)m_ParamList[0];
                        //int w_at = (int)m_ParamList[1]; //w_atは逆操作(Split)を行うためにのみ、記録される
                        Bunsetsu delBunsetsu = (Bunsetsu)sen.MergeBunsetsu(b_at);
                        if (delBunsetsu != null)
                        {
                            // 削除された文節をDBから切り離し、Transientなオブジェクトにする。
                            session.Delete(delBunsetsu);
                        }
                    }
                    break;
                case DOType.ChangeTag:
                    {
                        int b_at = (int)m_ParamList[0];
                        string newtag = (string)m_ParamList[2];
                        Bunsetsu b = (Bunsetsu)sen.Bunsetsus[b_at];
                        b.DependsAs = newtag;
                    }
                    break;
                case DOType.ChangeLexeme:
                    {
                        int wpos = (int)m_ParamList[0];
                        Lexeme newlex = (Lexeme)m_ParamList[1];
                        Word w = (Word)sen.Words[wpos];
                        m_ParamList[2] = w.Lex;  // oldlex
                        w.Lex = newlex;
                    }
                    break;
            }
        }

        public virtual void UnExecute(Sentence sen, ISession session)
        {
            switch (m_OpType)
            {
                case DOType.MoveArrow:
                    {
                        int ibmax = sen.Bunsetsus.Count;
                        int ib = (int)m_ParamList[0];
                        int id_org = (int)m_ParamList[1];
                        int id_new = (int)m_ParamList[2];
                        if (ib < 0 || ib >= ibmax || id_org < 0 || id_org >= ibmax || id_new < 0 || id_new >= ibmax)
                        {
                            throw new IndexOutOfRangeException("Invalid dependency index");
                        }
                        Bunsetsu b = (Bunsetsu)sen.Bunsetsus[ib];
                        b.DependsTo = (Bunsetsu)sen.Bunsetsus[id_org];
                    }
                    break;
                case DOType.Split:
                    {
                        int b_at = (int)m_ParamList[0];
                        //int w_at = (int)m_ParamList[1]; // 逆操作のMergeでは不要なパラメータ
                        Bunsetsu delBunsetsu = (Bunsetsu)sen.MergeBunsetsu(b_at);
                        if (delBunsetsu != null)
                        {
                            // 削除された文節をDBから切り離し、Transientなオブジェクトにする。
                            session.Delete(delBunsetsu);
                        }
                    }
                    break;
                case DOType.Merge:
                    {
                        int b_at = (int)m_ParamList[0];
                        int w_at = (int)m_ParamList[1];
                        Bunsetsu newBunsetsu = (Bunsetsu)sen.SplitBunsetsu(b_at, w_at);
                        if (newBunsetsu != null)
                        {
                            // 生成された文節をDBへ追加、Persistentオブジェクトにする。
                            session.Save(newBunsetsu);
                        }
                    }
                    break;
                case DOType.ChangeTag:
                    {
                        int b_at = (int)m_ParamList[0];
                        string oldtag = (string)m_ParamList[1];
                        Bunsetsu b = (Bunsetsu)sen.Bunsetsus[b_at];
                        b.DependsAs = oldtag;
                    }
                    break;
                case DOType.ChangeLexeme:
                    {
                        int wpos = (int)m_ParamList[0];
                        Lexeme oldlex = (Lexeme)m_ParamList[2];
                        Word w = (Word)sen.Words[wpos];
                        w.Lex = oldlex;
                    }
                    break;
            }
        }

        public override string ToString()
        {
            string s = "{" + this.m_OpType + ":";
            foreach (object o in m_ParamList)
            {
                s += o;
                s += ", ";
            }
            s += "}";
            return s;
        }
    }
}
