﻿using System;
using System.Text;
using System.IO;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Corpora.Annotations;

namespace ChaKi.Service.Readers
{
    public class CabochaMecabReader : CabochaReader, CorpusSourceReader
    {
        public CabochaMecabReader(Corpus corpus)
            : base(corpus)
        {
        }

        public override Lexeme AddLexeme(string s, LexiconBuilder lb)
        {
            return lb.AddEntryMecab(s);
        }

        public TagSet GetTagSet()
        {
            return m_TagSet;
        }
    }
}