﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.KwicView
{
    internal class Columns
    {
        public int[] Widths;

        public Columns()
        {
            this.Widths = new int[NColumns];
        }

        static Columns()
        {
            Default = new Columns();
            Default.Widths = DefaultHeaderWidthNonKwic;
        }

        public int GetSentenceOffset()
        {
            return Widths[0]+Widths[1]+Widths[2]+Widths[3]+Widths[4];
        }

        public int GetSentenceEndOffset()
        {
            return Widths[0] + Widths[1] + Widths[2] + Widths[3] + Widths[4] + Widths[5] + Widths[6] + Widths[7];
        }

        public int GetLeftWidth()
        {
            return this.Widths[5];
        }

        public int GetCenterOffset()
        {
            return Widths[0] + Widths[1] + Widths[2] + Widths[3] + Widths[4] + Widths[5];
        }

        public int GetMaxSentenceWidth()
        {
            return this.Widths[5] + Widths[6] + Widths[7];
        }

        public bool IsInSentence(int x)
        {
            return (x >= GetSentenceOffset() && x < GetSentenceEndOffset());
        }

        public bool IsInCheckBox(int x)
        {
            if (x >= this.Widths[0])
            {
                if (x - this.Widths[0] < this.Widths[1])
                {
                    return true;
                }
            }
            return false;
        }


        /// <summary>
        /// centerize->5,7カラムの幅を調整することで全体がtotalWidth内に収まるようにする。
        /// !enterize->7カラムの幅を調整することで全体がtotalWidth内に収まるようにする。
        /// </summary>
        public void AutoAdjust(int totalWidth, bool centerize)
        {
            int rest = totalWidth;
            for (int i = 0; i < NColumns; i++)
            {
                if (i != 5 && i != 7)
                {
                    rest -= this.Widths[i];
                }
            }
            if (rest <= 0)
            {
                return;
            }
            if (centerize)
            {
                DefaultHeaderWidthKwic[5] = DefaultHeaderWidthKwic[7] = rest / 2;
            }
            else
            {
                DefaultHeaderWidthNonKwic[7] = rest;
            }
        }

        #region Static definitions
        public static int NColumns = 8;
        public static Columns Default;

        public static string[] DefaultHeaderTextNonKwic =
        {
            "Index", "Check", "Corpus", "Char", "Sen",
            "", "", "Text"
        };
        public static int[] DefaultHeaderWidthNonKwic =
        {
            37, 24, 100, 44, 44,
            0, 0, 660 
        };
        public static string[] DefaultHeaderTextKwic =
        {
            "Index", "Check", "Corpus", "Char", "Sen",
            "Left", "Center", "Right"
        };
        public static int[] DefaultHeaderWidthKwic =
        {
            37, 24, 100, 44, 44,
            280, 100, 280
        };
        #endregion
    }
}
