using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Corpora;

namespace ChaKi.Panels
{
    public partial class GuidePanel : Form
    {
        public Corpus Corpus { get; set; }

        public GuidePanel()
        {
            InitializeComponent();

            // ftHg̃XgځiCorpus肳΁A̐ݒɏ]čĐݒ肷j
            int n = Lexeme.PropertyName.Count;
            this.dataGridView1.RowCount = n;
            for (int i = 0; i < n; i++)
            {
                this.dataGridView1[0, i].Value = Lexeme.PropertyName[(LP)i];
            }
        }

        public void SetLexeme(Lexeme lex)
        {
            for (int i = 0; i < Lexeme.PropertyName.Count; i++)
            {
                string value = lex.GetStringProperty((LP)i);
                if (value != null)
                {
                    this.dataGridView1[1, i].Value = value;
                }
                else
                {
                    this.dataGridView1[1, i].Value = "";
                }
            }
        }
    }
}