﻿using System;
using System.Windows.Forms;
using ChaKi.Common;
using ChaKi.Entity.Collocation;
using System.Collections.Generic;
using ChaKi.Entity.Corpora;
using System.Drawing;

namespace ChaKi.Views
{
    public partial class CollocationView : UserControl, IChaKiView
    {
        private CollocationList m_Model;

        public CollocationView()
        {
            InitializeComponent();

            this.dataGridView1.GridColor = Color.DarkGray;
            this.dataGridView1.RowTemplate.Height = 18;
        }

        public void SetModel(object model)
        {
            if (model == null)
            {
                return;
            }
            if (!(model is CollocationList))
            {
                throw new ArgumentException("Assigning invalid model to CollocationView");
            }
            m_Model = (CollocationList)model;
            if (m_Model != null)
            {
//                m_Model.OnLexemeCountAdded += new AddLexemeCountEventHandler(this.AddLexemeCountHandler);
            }
            this.dataGridView1.Columns.Clear();
            this.dataGridView1.ColumnCount = Lexeme.PropertyName.Count + m_Model.NColumns;
            int col = 0;
            for (int i = 0; i < Lexeme.PropertyName.Count; i++)
            {
                this.dataGridView1.Columns[col].Name = Lexeme.PropertyName[(LP)i];
                this.dataGridView1.Columns[col].Width = 70; //TODO: to be part of Persistent Setting
                this.dataGridView1.Columns[col].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleLeft;
                this.dataGridView1.Columns[col].DefaultCellStyle.BackColor = Color.Ivory;
                this.dataGridView1.Columns[col].Visible = !(m_Model.Cond.Filter.IsFiltered((LP)i));
                col++;
            }
            for (int i = 0; i < m_Model.NColumns; i++)
            {
                this.dataGridView1.Columns[col].Name = m_Model.ColumnTitles[i];
                this.dataGridView1.Columns[col].Width = 50; //TODO: to be part of Persistent Setting
                this.dataGridView1.Columns[col].DefaultCellStyle.Alignment = DataGridViewContentAlignment.MiddleRight;
                this.dataGridView1.Columns[col].DefaultCellStyle.BackColor = Color.LightGray;
                col++;
            }
            UpdateView();
        }

        public void SetVisible(bool f)
        {
            this.Visible = f;
        }

        /// <summary>
        /// Modelの内容からGridを生成しなおす。
        /// </summary>
        private void UpdateView()
        {
            this.dataGridView1.ResetRows();

            // Totalを初期化
            List<int> total = new List<int>();
            for (int i = 0; i < m_Model.NColumns; i++)
            {
                total.Add(0);
            }

            foreach (KeyValuePair<Lexeme, List<DIValue>> pair in m_Model.Rows)
            {
                int row = this.dataGridView1.Rows.Add();
                int col = 0;
                for (int i = 0; i < Lexeme.PropertyName.Count; i++)
                {
                    this.dataGridView1[col, row].Value = pair.Key.GetStringProperty((LP)i);
                    col++;
                }
                for (int i = 0; i < pair.Value.Count; i++)
                {
                    if (m_Model.ColumnIsDouble[i])
                    {
                        this.dataGridView1[col, row].Value = pair.Value[i].dval;
                    }
                    else
                    {
                        this.dataGridView1[col, row].Value = pair.Value[i].ival;
                        // int値かつHasTotalの場合、TOTALを加算
                        if (m_Model.ColumnHasTotal[i])
                        {
                            total[i] += pair.Value[i].ival;
                        }
                    }
                    col++;
                }
            }
            // TOTAL行をセット
            for (int i = 0; i < m_Model.NColumns; i++)
            {
                if (m_Model.ColumnHasTotal[i])
                {
                    this.dataGridView1[Lexeme.PropertyName.Count + i, 0].Value = total[i];
                }
            }

        }
    }
}
