﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;

namespace ChaKi.Entity.Corpora.Annotations
{
    public class Segment : Annotation
    {
        public Segment()
        {
            this.StartChar = -1;
            this.EndChar = -1;
        }

        public virtual long ID { get; set; }

        // セグメント開始位置番号（文字単位）
        public virtual int StartChar { get; set; }

        // セグメント開始位置番号（文字単位）
        public virtual int EndChar { get; set; }

        // このSegmentの開始位置にあるSentence (For Performance purpose)
        public virtual Sentence Sentence { get; set; }

        /// <summary>
        /// このSegmentを含むDocumentへの参照
        /// </summary>
        public virtual Document Doc { get; set; }
    }
}
