﻿using System.Collections.Generic;

namespace ChaKi.Entity.Corpora.Annotations
{
    public class TagSet
    {
        public virtual int ID { get; set; }
        public virtual string Name { get; set; }
        public virtual IList<Tag> Tags { get; set; }
        public virtual TagSetVersion Version { get; set; }
        public virtual string Comment { get; set; }

        public TagSet()
        {
            this.Name = string.Empty;
            this.Tags = new List<Tag>();
        }

        public TagSet(string name)
        {
            this.Name = name;
            this.Tags = new List<Tag>();
        }

        public void AddTag(Tag tag)
        {
            this.Tags.Add(tag);
            tag.Version = this.Version;
        }

        public Tag FindTag(string type, string name)
        {
            foreach (Tag t in this.Tags)
            {
                if (t.Type.Equals(type) && t.Name.Equals(name))
                {
                    return t;
                }
            }
            return null;
        }
    }
}
