﻿using System.Collections.Generic;
using ChaKi.Entity.Corpora.Annotations;

namespace ChaKi.Entity.Corpora
{
    public class Project
    {
        public virtual int ID { get; set; }

        public virtual IList<TagSet> TagSetList { get; set; }

        public virtual int DocumentPrivilege { get; set; }

        public virtual int TagsetPrivilege { get; set; }

        public Project()
        {
            this.ID = 0;
            this.TagSetList = new List<TagSet>();
        }

        public void AddTagSet(TagSet ts)
        {
            this.TagSetList.Add(ts);
        }
    }
}
