﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Serialization;

namespace ChaKi.Entity.Corpora
{
    public class Segment : Annotation
    {
        private int m_id;
        private int m_Start;
        private int m_End;
        // For Performance purpose:
        private Sentence m_Sentence;    // このSegmentの開始位置にあるSentence

        public Segment()
        {
            m_Start = -1;
            m_End = -1;
        }

        public virtual int ID
        {
            get { return m_id; }
            set { m_id = value; }
        }

        // セグメント開始位置番号（文字単位）
        public virtual int StartChar
        {
            get { return m_Start; }
            set { m_Start = value; }
        }

        // セグメント開始位置番号（文字単位）
        public virtual int EndChar
        {
            get { return m_End; }
            set { m_End = value; }
        }

        public virtual Sentence Sentence
        {
            get { return m_Sentence; }
            set { m_Sentence = value; }
        }
    }
}
