﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using System.ComponentModel;
using System.Collections.ObjectModel;
using System.Xml.Serialization;

namespace ChaKi.Entity.Kwic
{
    public class AddLexemeCountEventArgs : EventArgs
    {
        public AddLexemeCountEventArgs(int index, Lexeme lex, Corpus cps, long count)
        {
            this.Index = index;
            this.Lex = lex;
            this.Cps = cps;
            this.Count = count;
        }
        public int Index;
        public Lexeme Lex;
        public Corpus Cps;
        public long Count;
    }

    public delegate void AddLexemeCountEventHandler(object sender, AddLexemeCountEventArgs e);

    public class LexemeCount
    {
        [XmlIgnore]
        public Lexeme Lex;

        [XmlIgnore]
        public Dictionary<Corpus, long> Counts;

        public LexemeCount()
        {
            this.Lex = null;
            this.Counts = new Dictionary<Corpus, long>();
        }

        public LexemeCount(Lexeme lex, Corpus cps, long count)
        {
            this.Lex = lex;
            this.Counts = new Dictionary<Corpus, long>();
            this.Counts.Add(cps, count);
        }
    }


    /// <summary>
    /// WordListFormに対するModelオブジェクト。
    /// Modelオブジェクトではあるが、データの管理はView=DataGridViewも独自に
    /// 行っているため、二重に管理することになる。
    /// </summary>
    public class LexemeCountList : KeyedCollection<Lexeme, LexemeCount>
    {
        public event AddLexemeCountEventHandler OnLexemeCountAdded;

        public LexemeCountList()
            : base()
        {
        }
        public LexemeCountList(IEqualityComparer<Lexeme> comp)
            : base(comp)
        {
        }

        protected override Lexeme GetKeyForItem(LexemeCount lc)
        {
            return lc.Lex;
        }

        public void Add(Lexeme lex, Corpus cps, long count)
        {
            int index = -1;
            LexemeCount lc = null;
            try {
                lc = this[lex];
                index = IndexOf(lc);
            }
            catch
            {
            }
            if (index < 0)
            {
                // 新しいLexemeなので、リストに追加する
                lc = new LexemeCount(lex, cps, count);
                this.Add(lc);
            } else {
                // 既にリストにあるLexemeなので、カウントのみ更新する
                lc.Counts[cps] = count;
            }

            // リスナにモデル更新を通知
            if (OnLexemeCountAdded != null)
            {
                OnLexemeCountAdded(this, new AddLexemeCountEventArgs(index, lex, cps, count));
            }
        }

    }
}
