using System;
using System.Text;
using System.IO;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Corpora.Annotations;

namespace ChaKi.Service.Readers
{
    public class CabochaChasenReader : CabochaReader, CorpusSourceReader
    {
        public CabochaChasenReader(Corpus corpus)
            : base(corpus)
        {
        }

        public override Lexeme AddLexeme(string s, LexiconBuilder lb)
        {
            return lb.AddEntryChasen(s);
        }

        public TagSet GetTagSet()
        {
            return m_TagSet;
        }
    }
}
