﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Kwic;
using ChaKi.Entity.Search;
using ChaKi.Entity.Corpora;
using NHibernate;
using System.Collections;

namespace ChaKi.Service.Search
{
    public class SentenceListService : SearchServiceBase
    {
        private KwicList m_Model;

        public SentenceListService(KwicList model, SearchConditionsSequence condSeq, CommandProgress progress)
            : base(condSeq, progress)
        {
            m_Model = model;
        }

        /// <summary>
        /// コーパスごとのSentenceList本体
        /// </summary>
        /// <param name="c"></param>
        protected override void ExecuteSearchSession(Corpus c)
        {
            SearchConditions cond = m_CondSeq.Last;  //TODO: 絞り込み等ではCondSeqを順次検索しなければならない

            // Sentence Listのクエリを生成する
            string qstr = QueryBuilder.Instance.BuildSentenceListQuery(cond); 
            IQuery query = m_Session.CreateQuery(qstr);
            IList queryResult = query.List();
            int totalCount = queryResult.Count;

            // ここまでで検索は終了。

            // 検索されたSentenceに対して、文内容をKwicに変換・出力する
            int n = 0;
            m_Progress.SetRange(totalCount);
            foreach (Sentence sen in queryResult)
            {
                c.Sentences.Add(sen);
                KwicItem ki = new KwicItem(c, sen.ID, sen.StartChar, sen.EndChar);
                foreach (Word w in sen.Words)
                {
                    Lexeme lex = w.Lex;
                    ki.Right.AddLexeme(lex, 0);
                }

                m_Model.AddKwicItem(ki);
                m_Progress.Increment();
                n++;
            }
        }
    }
}
