/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.ColorGroupsTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ColorGroupsTableModel
extends AbstractTableModelWithComboBoxModel<ColorGroupsTableRow> {
    private static final long serialVersionUID = 2952439955567262351L;
    private static final String[] colorGroupColumnNames;
    private static final Logger logger;
    private int serialCounter = 1;

    ColorGroupsTableModel() {
    }

    @Override
    public int getColumnCount() {
        return colorGroupColumnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return colorGroupColumnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ColorGroupsTableRow colorGroup = (ColorGroupsTableRow)this.elements.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return colorGroup.getLocalizedName();
            }
        }
        return "****";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ColorGroupsTableRow colorGroup = (ColorGroupsTableRow)this.elements.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    String localizedName = (String)aValue;
                    if (localizedName == null || localizedName.trim().length() <= 0) break;
                    colorGroup.setLocalizedName(localizedName.trim());
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "value set failed. (" + rowIndex + ", " + columnIndex + "): " + aValue, ex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable();
    }

    public void addNewColorGroup() {
        String id = "cg" + UUID.randomUUID().toString();
        String localizedName = "ColorGroup" + this.serialCounter++;
        ColorGroupsTableRow colorGroup = new ColorGroupsTableRow(id, localizedName);
        this.addRow(colorGroup);
    }

    static {
        logger = Logger.getLogger(ColorGroupsTableModel.class.getName());
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/profileditdialog");
        colorGroupColumnNames = new String[]{strings.getProperty("colorgroup.column.colorgroupname")};
    }
}

