/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.ui.AbstractImportPanel;
import charactermanaj.ui.ExportPartsResolver;
import charactermanaj.ui.ExportPartsSelectModel;
import charactermanaj.ui.ExportPartsTableModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPartsSelectPanel
extends AbstractImportPanel
implements ExportPartsResolver {
    private static final long serialVersionUID = 1L;
    private ExportPartsTableModel partsTableModel;
    private JTable partsTable;
    private Action actSelectAll;
    private Action actDeselectAll;
    private Action actSort;
    private Action actSortByTimestamp;

    protected ExportPartsSelectPanel(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/exportwizdialog");
        this.setName("choosePartsPanel");
        this.setBorder(BorderFactory.createTitledBorder(strings.getProperty("parts.title")));
        this.setLayout(new BorderLayout());
        this.partsTableModel = new ExportPartsTableModel();
        this.partsTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                ExportPartsSelectPanel.this.fireChangeEvent();
            }
        });
        this.loadPartsInfo(partsSpecResolver);
        AppConfig appConfig = AppConfig.getInstance();
        final Color disabledForeground = appConfig.getDisabledCellForgroundColor();
        this.partsTable = new JTable(this.partsTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                if (comp instanceof JCheckBox) {
                    comp.setEnabled(this.isCellEditable(row, column) && this.isEnabled());
                }
                comp.setForeground(this.isEnabled() ? (this.isCellSelected(row, column) ? this.getSelectionForeground() : this.getForeground()) : disabledForeground);
                return comp;
            }
        };
        this.partsTable.setShowGrid(true);
        this.partsTable.setGridColor(appConfig.getGridColor());
        this.partsTable.setAutoResizeMode(0);
        this.partsTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.partsTableModel.adjustColumnModel(this.partsTable.getColumnModel());
        this.partsTable.setSelectionMode(2);
        this.partsTable.setRowSelectionAllowed(true);
        AbstractAction actPartsSetCheck = new AbstractAction(strings.getProperty("parts.popup.check")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int[] selRows = ExportPartsSelectPanel.this.partsTable.getSelectedRows();
                ExportPartsSelectPanel.this.partsTableModel.setCheck(selRows, true);
            }
        };
        AbstractAction actPartsUnsetCheck = new AbstractAction(strings.getProperty("parts.popup.uncheck")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int[] selRows = ExportPartsSelectPanel.this.partsTable.getSelectedRows();
                ExportPartsSelectPanel.this.partsTableModel.setCheck(selRows, false);
            }
        };
        JPopupMenu partsTablePopupMenu = new JPopupMenu();
        partsTablePopupMenu.add(actPartsSetCheck);
        partsTablePopupMenu.add(actPartsUnsetCheck);
        this.partsTable.setComponentPopupMenu(partsTablePopupMenu);
        this.add((Component)new JScrollPane(this.partsTable), "Center");
        this.actSelectAll = new AbstractAction(strings.getProperty("parts.btn.selectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ExportPartsSelectPanel.this.onSelectAll();
            }
        };
        this.actDeselectAll = new AbstractAction(strings.getProperty("parts.btn.deselectAll")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ExportPartsSelectPanel.this.onDeselectAll();
            }
        };
        this.actSort = new AbstractAction(strings.getProperty("parts.btn.sort")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ExportPartsSelectPanel.this.onSort();
            }
        };
        this.actSortByTimestamp = new AbstractAction(strings.getProperty("parts.btn.sortByTimestamp")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ExportPartsSelectPanel.this.onSortByTimestamp();
            }
        };
        JPanel btnPanel = new JPanel();
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        JButton btnSelectAll = new JButton(this.actSelectAll);
        btnPanel.add((Component)btnSelectAll, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        JButton btnDeselectAll = new JButton(this.actDeselectAll);
        btnPanel.add((Component)btnDeselectAll, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        JButton btnSort = new JButton(this.actSort);
        btnPanel.add((Component)btnSort, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        JButton btnSortByTimestamp = new JButton(this.actSortByTimestamp);
        btnPanel.add((Component)btnSortByTimestamp, gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        this.add((Component)btnPanel, "South");
    }

    protected void loadPartsInfo(PartsSpecResolver partsSpecResolver) {
        this.partsTableModel.clear();
        for (PartsCategory partsCategory : partsSpecResolver.getPartsCategories()) {
            Map<PartsIdentifier, PartsSpec> partsSpecMap = partsSpecResolver.getPartsSpecMap(partsCategory);
            for (Map.Entry<PartsIdentifier, PartsSpec> entry : partsSpecMap.entrySet()) {
                PartsIdentifier partsIdentifier = entry.getKey();
                PartsSpec partsSpec = entry.getValue();
                ExportPartsSelectModel model = new ExportPartsSelectModel(partsIdentifier, partsSpec, false);
                this.partsTableModel.addRow(model);
            }
        }
        this.partsTableModel.sort();
    }

    protected void onSelectAll() {
        this.partsTableModel.selectAll();
    }

    protected void onDeselectAll() {
        this.partsTableModel.deselectAll();
    }

    protected void onSort() {
        this.partsTableModel.sort();
        if (this.partsTableModel.getRowCount() > 0) {
            Rectangle rct = this.partsTable.getCellRect(0, 0, true);
            this.partsTable.scrollRectToVisible(rct);
        }
    }

    protected void onSortByTimestamp() {
        this.partsTableModel.sortByTimestamp();
        if (this.partsTableModel.getRowCount() > 0) {
            Rectangle rct = this.partsTable.getCellRect(0, 0, true);
            this.partsTable.scrollRectToVisible(rct);
        }
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> getSelectedParts() {
        return this.partsTableModel.getSelectedParts();
    }

    @Override
    public Map<PartsSet, List<PartsIdentifier>> checkMissingPartsList(Collection<PartsSet> partsSets) {
        return this.partsTableModel.checkMissingPartsList(partsSets);
    }

    @Override
    public void selectByPartsSet(Collection<PartsSet> partsSets) {
        this.partsTableModel.selectByPartsSet(partsSets);
    }

    @Override
    public int getSelectedCount() {
        return this.partsTableModel.getSelectedCount();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.partsTable.setEnabled(enabled);
        this.partsTableModel.setEnabled(enabled);
        this.actSelectAll.setEnabled(enabled);
        this.actDeselectAll.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

