/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLUtilities {
    private XMLUtilities() {
    }

    public static Document loadDocument(InputStream is) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            final ArrayList errors = new ArrayList();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }

                public void warning(SAXParseException exception) throws SAXException {
                    errors.add(exception);
                }
            });
            Document doc = builder.parse(is);
            if (errors.size() > 0) {
                throw (SAXParseException)errors.get(0);
            }
            return doc;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Exception.", ex);
        }
        catch (SAXException ex) {
            IOException ex2 = new IOException("xml read failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    public static String getLocalizedElementText(Element parent, String elementName, String lang) {
        String text = null;
        for (Element childelm : XMLUtilities.getChildElements(parent, elementName)) {
            String langNm;
            String val = childelm.getTextContent();
            if (text == null) {
                text = val;
            }
            if (!lang.equals(langNm = childelm.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang")) || val.length() <= 0) continue;
            text = val;
            break;
        }
        return text;
    }

    public static String getElementText(Element parent, String elementName) {
        Iterator<Element> iterator = XMLUtilities.getChildElements(parent, elementName).iterator();
        if (iterator.hasNext()) {
            Element childelm = iterator.next();
            return childelm.getTextContent();
        }
        return null;
    }

    public static Element getFirstChildElement(Element parent, String name) {
        Iterator<Element> iterator = XMLUtilities.getChildElements(parent, name).iterator();
        if (iterator.hasNext()) {
            Element elm = iterator.next();
            return elm;
        }
        return null;
    }

    public static Iterable<Element> getChildElements(Element elm, final String name) {
        return XMLUtilities.iterable(elm.getChildNodes(), new Filter(){

            public boolean isAccept(Node node) {
                return node != null && node.getNodeType() == 1 && (name == null || name.equals(node.getNodeName()));
            }
        });
    }

    public static <T extends Node> Iterable<T> iterable(NodeList nodeList) {
        return XMLUtilities.iterable(nodeList, null);
    }

    public static <T extends Node> Iterable<T> iterable(final NodeList nodeList, final Filter filter) {
        final int mx = nodeList == null ? 0 : nodeList.getLength();
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int idx = 0;
                    private Node nextNode = this.getNextNode();

                    private Node getNextNode() {
                        while (this.idx < mx) {
                            Node node = nodeList.item(this.idx++);
                            if (filter != null && !filter.isAccept(node)) continue;
                            return node;
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextNode != null;
                    }

                    @Override
                    public T next() {
                        Node cur = this.nextNode;
                        if (cur == null) {
                            throw new NoSuchElementException();
                        }
                        this.nextNode = this.getNextNode();
                        return cur;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static interface Filter {
        public boolean isAccept(Node var1);
    }
}

