/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

public final class JavaVersionUtils {
    private JavaVersionUtils() {
    }

    public static double getJavaVersion() {
        try {
            String version = System.getProperty("java.version");
            String[] versions = version.split("\\.");
            if (versions.length > 2) {
                return Double.valueOf(versions[0] + "." + versions[1]);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return 0.0;
    }

    public static int[] getJavaVersions() {
        return JavaVersionUtils.getJavaVersions(System.getProperty("java.version"));
    }

    private static int[] getJavaVersions(String version) {
        int[] ret = new int[4];
        try {
            int posIdentifier = version.indexOf(45);
            if (posIdentifier >= 0) {
                version = version.substring(0, posIdentifier);
            }
            int posUpdate = version.indexOf("_");
            int update = 0;
            if (posUpdate >= 0) {
                update = Integer.parseInt(version.substring(posUpdate + 1));
                version = version.substring(0, posUpdate);
            }
            String[] versions = version.split("\\.");
            for (int idx = 0; idx < 3 && idx < versions.length; ++idx) {
                ret[idx] = Integer.parseInt(versions[idx]);
            }
            ret[3] = update;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
        }
        return ret;
    }
}

